/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestEntity;
import party.lemons.biomemakeover.crafting.witch.WitchQuestHandler;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.crafting.witch.data.QuestCategories;
import party.lemons.biomemakeover.entity.ai.WitchLookAtCustomerGoal;
import party.lemons.biomemakeover.entity.ai.WitchStopFollowingCustomerGoal;
import party.lemons.biomemakeover.init.BMItems;

@Mixin(value={Witch.class})
public class WitchMixin_Quests
extends Raider
implements WitchQuestEntity {
    @Shadow
    private NearestAttackableWitchTargetGoal<Player> f_34131_;
    private Player customer;
    private WitchQuestList quests;
    private int replenishTime;
    private int despawnShield = 0;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void onConstruct(EntityType<? extends Witch> entityType, Level world, CallbackInfo cbi) {
        this.quests = new WitchQuestList();
        this.quests.populate(this.m_21187_());
        this.replenishTime = world.f_46441_.nextInt(24000);
    }

    @Inject(at={@At(value="TAIL")}, method={"registerGoals"})
    public void initGoals(CallbackInfo cbi) {
        this.f_21346_.m_25363_(this.f_34131_);
        this.f_34131_ = new NearestAttackableWitchTargetGoal((Raider)this, Player.class, 10, true, false, e -> e.m_6095_() == EntityType.f_20532_ && !this.canInteract((Player)e));
        this.f_21346_.m_25352_(3, this.f_34131_);
        this.f_21345_.m_25352_(1, (Goal)new WitchStopFollowingCustomerGoal((Witch)this));
        this.f_21345_.m_25352_(1, (Goal)new WitchLookAtCustomerGoal((Witch)this));
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_() && !this.hasCustomer() && this.canInteract(player)) {
            if (!this.f_19853_.m_5776_()) {
                this.despawnShield = 12000;
                this.setCurrentCustomer(player);
                this.sendQuests(player, this.m_5446_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7625_(DamageSource damageSource, boolean causedByPlayer) {
        if (causedByPlayer && this.f_19796_.nextInt(20) == 0) {
            this.m_19983_(new ItemStack((ItemLike)BMItems.WITCH_HAT.get()));
        }
        super.m_7625_(damageSource, causedByPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.f_19853_.m_5776_()) {
            if (this.despawnShield > 0) {
                --this.despawnShield;
            }
            if (this.replenishTime > 0) {
                --this.replenishTime;
            } else {
                for (int i = this.quests.size(); i < 3; ++i) {
                    this.quests.add(WitchQuestHandler.createQuest(this.f_19796_));
                }
                this.replenishTime = 3000 + this.f_19796_.nextInt(21000);
            }
        }
    }

    public boolean m_6779_(LivingEntity target) {
        if (target.m_6095_() == EntityType.f_20532_ && this.canInteract((Player)target)) {
            return false;
        }
        return super.m_6779_(target);
    }

    @Override
    public boolean canInteract(Player player) {
        return this.m_5448_() == null && !this.m_37886_() && this.playerHasHat(player) && QuestCategories.hasQuests();
    }

    public boolean playerHasHat(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() == BMItems.WITCH_HAT.get();
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.resetCustomer();
    }

    protected void resetCustomer() {
        this.setCurrentCustomer(null);
    }

    @Override
    public void setCurrentCustomer(Player customer) {
        this.customer = customer;
    }

    @Override
    public Player getCurrentCustomer() {
        return this.customer;
    }

    @Override
    public WitchQuestList getQuests() {
        return this.quests;
    }

    @Override
    public void setQuestsFromServer(WitchQuestList quests) {
        this.quests = quests;
    }

    @Override
    public void completeQuest(WitchQuest quest) {
    }

    @Override
    public Level getWitchLevel() {
        return this.f_19853_;
    }

    @Override
    public SoundEvent getYesSound() {
        return SoundEvents.f_12549_;
    }

    @Override
    public boolean hasCustomer() {
        return this.getCurrentCustomer() != null;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Quests", (Tag)this.quests.toTag());
        tag.m_128405_("DespawnShield", this.despawnShield);
        tag.m_128405_("ReplenishTime", this.replenishTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.quests = new WitchQuestList(tag.m_128469_("Quests"));
        this.despawnShield = tag.m_128451_("DespawnShield");
        this.replenishTime = tag.m_128451_("ReplenishTime");
    }

    public boolean m_6785_(double d) {
        if (this.despawnShield > 0) {
            return false;
        }
        return super.m_6785_(d);
    }

    public boolean m_8023_() {
        if (this.despawnShield > 0) {
            return true;
        }
        return super.m_8023_();
    }

    public void m_7895_(int i, boolean bl) {
    }

    public SoundEvent m_7930_() {
        return null;
    }

    protected WitchMixin_Quests(EntityType<? extends Raider> entityType, Level level) {
        super(entityType, level);
    }
}

