/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.golem;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import party.lemons.biomemakeover.entity.PlayerCreatable;

public final class GolemHandler {
    private static List<GolemInstance> golems = Lists.newArrayList();

    public static void addPattern(BlockPattern fullPattern, BlockPattern basePattern, GolemResult result) {
        golems.add(new GolemInstance(fullPattern, basePattern, result));
    }

    public static boolean canDispenseGolem(LevelReader levelReader, BlockPos blockPos) {
        for (GolemInstance golemInstance : golems) {
            if (golemInstance.basePattern.m_61184_(levelReader, blockPos) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAndCreateGolem(Level level, BlockPos pos) {
        for (GolemInstance golem : golems) {
            BlockPattern.BlockPatternMatch fullMatch = golem.fullPattern.m_61184_((LevelReader)level, pos);
            if (fullMatch == null) continue;
            for (int x = 0; x < golem.fullPattern.m_61203_(); ++x) {
                for (int y = 0; y < golem.fullPattern.m_61202_(); ++y) {
                    BlockInWorld block = fullMatch.m_61229_(x, y, 0);
                    level.m_7731_(block.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    level.m_46796_(2001, block.m_61176_(), Block.m_49956_((BlockState)block.m_61168_()));
                }
            }
            BlockPos placePosition = fullMatch.m_61229_(golem.fullPattern.m_61203_() / 2, golem.fullPattern.m_61202_() - 1, 0).m_61176_();
            if (golem.result.spawnGolem(level, golem, pos, placePosition)) {
                for (int x = 0; x < golem.fullPattern.m_61203_(); ++x) {
                    for (int y = 0; y < golem.fullPattern.m_61202_(); ++y) {
                        BlockInWorld removePosition = fullMatch.m_61229_(x, y, 0);
                        level.m_6289_(removePosition.m_61176_(), Blocks.f_50016_);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private GolemHandler() {
    }

    public record GolemInstance(BlockPattern fullPattern, BlockPattern basePattern, GolemResult result) {
    }

    @FunctionalInterface
    public static interface GolemResult {
        public boolean spawnGolem(Level var1, GolemInstance var2, BlockPos var3, BlockPos var4);
    }

    public static class SummonGolemResult<T extends AbstractGolem>
    implements GolemResult {
        private final EntityType<T> golemType;

        public SummonGolemResult(EntityType<T> golem) {
            this.golemType = golem;
        }

        @Override
        public boolean spawnGolem(Level level, GolemInstance golemInstance, BlockPos pumpkinPos, BlockPos placePosition) {
            AbstractGolem golem = (AbstractGolem)this.golemType.m_20615_(level);
            ((PlayerCreatable)golem).setPlayerCreated(true);
            golem.m_7678_((double)placePosition.m_123341_() + 0.5, (double)placePosition.m_123342_() + 0.05, (double)placePosition.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)golem);
            for (ServerPlayer serverPlayer : level.m_45976_(ServerPlayer.class, golem.m_142469_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)golem);
            }
            return true;
        }
    }
}

