/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import party.lemons.biomemakeover.level.feature.mansion.LayoutType;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.util.BMUtil;
import party.lemons.biomemakeover.util.Grid;

public class MansionRoom {
    protected final RoomLayout layout = new RoomLayout();
    protected final BlockPos position;
    protected RoomType type;
    protected LayoutType layoutType;
    public boolean active = true;
    private int sortValue = 0;

    public MansionRoom(BlockPos position, RoomType type) {
        this.position = position;
        this.type = type;
        this.layoutType = LayoutType.NORMAL;
    }

    public RoomType getRoomType() {
        return this.type;
    }

    public void setRoomType(RoomType type) {
        this.type = type;
    }

    public void setLayout(MansionLayout layout, Random random) {
        Grid<MansionRoom> lo = layout.getLayout();
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            MansionRoom neighbour = lo.get(this.getPosition().m_142300_(dir));
            if (neighbour == null) continue;
            switch (this.layoutType) {
                case REQUIRED: {
                    this.layout.put(dir, true);
                    neighbour.layout.put(dir.m_122424_(), true);
                }
            }
        }
    }

    public RoomLayout getLayout() {
        return this.layout;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.layoutType = layoutType;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public ResourceLocation getTemplate(Random random) {
        if (this.type != RoomType.CORRIDOR) {
            return this.type.getRandomTemplate(this.position, random);
        }
        List<ResourceLocation> ids = switch (this.layout.doorCount()) {
            case 1 -> MansionFeature.CORRIDOR_STRAIGHT;
            case 2 -> {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() || ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    yield MansionFeature.CORRIDOR_STRAIGHT;
                }
                yield MansionFeature.CORRIDOR_CORNER;
            }
            case 3 -> MansionFeature.CORRIDOR_T;
            case 4 -> MansionFeature.CORRIDOR_CROSS;
            default -> MansionFeature.STAIR_DOWN;
        };
        return ids.get(random.nextInt(ids.size()));
    }

    public Rotation getRotation(Random random) {
        if (this.type.hasColumnRotation()) {
            int index = Math.abs((this.getPosition().m_123341_() + this.getPosition().m_123343_()) % 4);
            return Rotation.values()[index];
        }
        if (this.type == RoomType.GARDEN) {
            return Rotation.m_55956_((Random)random);
        }
        if (this.type != RoomType.CORRIDOR) {
            return Rotation.m_55956_((Random)random);
        }
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
            }
            case 4: {
                return Rotation.values()[random.nextInt(Rotation.values().length)];
            }
            case 0: {
                return Rotation.NONE;
            }
        }
        return null;
    }

    public BlockPos getOffsetForRotation(BlockPos offsetPos, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return offsetPos;
            }
            case CLOCKWISE_90: {
                return offsetPos.m_142082_(10, 0, 0);
            }
            case CLOCKWISE_180: {
                return offsetPos.m_142082_(10, 0, 10);
            }
            case COUNTERCLOCKWISE_90: {
                return offsetPos.m_142082_(0, 0, 10);
            }
        }
        return offsetPos;
    }

    public boolean isConnected(Direction direction) {
        return (Boolean)this.layout.get(direction);
    }

    public boolean canSupportRoof() {
        return true;
    }

    public void setSortValue(int sortValue) {
        this.sortValue = sortValue;
    }

    public int getSortValue() {
        return this.sortValue;
    }

    public boolean hasGroundModifications() {
        return this.getPosition().m_123342_() == 0;
    }

    public void addWalls(Random random, BlockPos wallPos, StructureManager manager, Grid<MansionRoom> roomGrid, StructurePiecesBuilder children) {
        boolean ground = this.hasGroundModifications();
        if (this.getRoomType().hasWalls()) {
            BlockPos cornerPos1;
            if (this.isConnected(Direction.NORTH)) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getInnerWall(random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground, false));
            } else if (!roomGrid.contains(this.getPosition().m_142127_()) || !roomGrid.get(this.getPosition().m_142127_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.NORTH, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11), Rotation.CLOCKWISE_180, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_142127_())) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getFlatWall(random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground, false));
            }
            if (this.isConnected(Direction.WEST)) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getInnerWall(random), wallPos, Rotation.CLOCKWISE_90, ground, false));
            } else if (!roomGrid.contains(this.getPosition().m_142125_()) || !roomGrid.get(this.getPosition().m_142125_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.WEST, roomGrid, random), wallPos.m_142127_(), Rotation.CLOCKWISE_90, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_142125_())) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getFlatWall(random), wallPos, Rotation.CLOCKWISE_90, ground, false));
            }
            if (!roomGrid.contains(this.getPosition().m_142126_()) || !roomGrid.get(this.getPosition().m_142126_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.EAST, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11).m_142125_().m_142383_(11), Rotation.COUNTERCLOCKWISE_90, ground, true));
            }
            if (!roomGrid.contains(this.getPosition().m_142128_()) || !roomGrid.get(this.getPosition().m_142128_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.SOUTH, roomGrid, random), wallPos.m_5484_(Direction.SOUTH, 10).m_142125_(), Rotation.NONE, ground, true));
            }
            if (roomGrid.contains(cornerPos1 = this.getPosition().m_142300_(Direction.NORTH).m_142300_(Direction.WEST)) && roomGrid.get(cornerPos1).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, MansionFeature.CORNER_FILLER.toString(), wallPos.m_142300_(Direction.WEST).m_142300_(Direction.NORTH).m_142082_(0, 0, 0), Rotation.NONE, ground, false));
            }
        }
    }

    public String getInnerWall(Random random) {
        return MansionFeature.INNER_WALL.get(random.nextInt(MansionFeature.INNER_WALL.size())).toString();
    }

    public String getFlatWall(Random random) {
        return MansionFeature.FLAT_WALL.get(random.nextInt(MansionFeature.FLAT_WALL.size())).toString();
    }

    public String getOuterWall(Direction dir, Grid<MansionRoom> roomGrid, Random random) {
        if (this.getPosition().m_123342_() > 0) {
            if (this.getRoomType().hasWindows() && random.nextFloat() < 0.95f && !roomGrid.contains(this.getPosition().m_142300_(dir))) {
                return MansionFeature.OUTER_WINDOW.get(random.nextInt(MansionFeature.OUTER_WINDOW.size())).toString();
            }
            return MansionFeature.OUTER_WALL.get(random.nextInt(MansionFeature.OUTER_WALL.size())).toString();
        }
        return MansionFeature.OUTER_WALL_BASE.get(random.nextInt(MansionFeature.OUTER_WALL_BASE.size())).toString();
    }

    public void setLayout(MansionRoom currentRoom) {
        for (Direction direction : BMUtil.HORIZONTALS) {
            this.getLayout().put(direction, (Boolean)currentRoom.getLayout().get(direction));
        }
    }
}

