/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.slf4j.Logger;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.AbstractTapestryBlock;
import party.lemons.biomemakeover.block.AbstractTapestryWallBlock;
import party.lemons.biomemakeover.block.IvyBlock;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.util.DirectionalDataHandler;
import party.lemons.biomemakeover.util.Grid;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.biomemakeover.util.extension.Stuntable;
import party.lemons.biomemakeover.util.registry.WoodTypeInfo;

public class MansionFeature
extends StructureFeature<NoneFeatureConfiguration> {
    public static final BlockIgnoreProcessor IGNORE_AIR_AND_STRUCTURE_BLOCKS = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50016_, (Object)Blocks.f_50677_, (Object)BMBlocks.DIRECTIONAL_DATA.get()));
    public static final BlockIgnoreProcessor IGNORE_STRUCTURE_BLOCKS = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50677_, (Object)BMBlocks.DIRECTIONAL_DATA.get()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation LOOT_ARROW = BiomeMakeover.ID("mansion/arrows");
    private static final ResourceLocation LOOT_DUNGEON_JUNK = BiomeMakeover.ID("mansion/dungeon_junk");
    private static final ResourceLocation LOOT_DUNGEON_STANDARD = BiomeMakeover.ID("mansion/dungeon");
    private static final ResourceLocation LOOT_DUNGEON_GOOD = BiomeMakeover.ID("mansion/dungeon_good");
    private static final ResourceLocation LOOT_JUNK = BiomeMakeover.ID("mansion/junk");
    private static final ResourceLocation LOOT_STANDARD = BiomeMakeover.ID("mansion/standard");
    private static final ResourceLocation LOOT_GOOD = BiomeMakeover.ID("mansion/good");
    public static List<ResourceLocation> CORRIDOR_STRAIGHT = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_1"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_2"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_3"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_4"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_5"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_6"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_7"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_8")});
    public static List<ResourceLocation> CORRIDOR_CORNER = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/corridor/corner/corridor_corner_1"), BiomeMakeover.ID("mansion/corridor/corner/corridor_corner_2"), BiomeMakeover.ID("mansion/corridor/corner/corridor_corner_3")});
    public static List<ResourceLocation> CORRIDOR_T = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/corridor/t/corridor_t_1"), BiomeMakeover.ID("mansion/corridor/t/corridor_t_2"), BiomeMakeover.ID("mansion/corridor/t/corridor_t_3")});
    public static List<ResourceLocation> CORRIDOR_CROSS = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_1"), BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_2"), BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_3"), BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_4")});
    public static List<ResourceLocation> ROOMS = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/room/room_1"), BiomeMakeover.ID("mansion/room/room_2"), BiomeMakeover.ID("mansion/room/room_3"), BiomeMakeover.ID("mansion/room/room_4"), BiomeMakeover.ID("mansion/room/room_5"), BiomeMakeover.ID("mansion/room/room_6"), BiomeMakeover.ID("mansion/room/room_7"), BiomeMakeover.ID("mansion/room/room_8"), BiomeMakeover.ID("mansion/room/room_9"), BiomeMakeover.ID("mansion/room/room_10"), BiomeMakeover.ID("mansion/room/room_11"), BiomeMakeover.ID("mansion/room/room_12"), BiomeMakeover.ID("mansion/room/room_13"), BiomeMakeover.ID("mansion/room/room_14"), BiomeMakeover.ID("mansion/room/room_15"), BiomeMakeover.ID("mansion/room/room_16"), BiomeMakeover.ID("mansion/room/room_17"), BiomeMakeover.ID("mansion/room/room_18"), BiomeMakeover.ID("mansion/room/room_19"), BiomeMakeover.ID("mansion/room/room_20"), BiomeMakeover.ID("mansion/room/room_21"), BiomeMakeover.ID("mansion/room/room_22"), BiomeMakeover.ID("mansion/room/room_23"), BiomeMakeover.ID("mansion/room/room_24"), BiomeMakeover.ID("mansion/room/room_25"), BiomeMakeover.ID("mansion/room/room_26"), BiomeMakeover.ID("mansion/room/room_27"), BiomeMakeover.ID("mansion/room/room_28"), BiomeMakeover.ID("mansion/room/room_29"), BiomeMakeover.ID("mansion/room/room_30"), BiomeMakeover.ID("mansion/room/room_31"), BiomeMakeover.ID("mansion/room/room_32"), BiomeMakeover.ID("mansion/room/room_33"), BiomeMakeover.ID("mansion/room/room_34")});
    public static List<ResourceLocation> ROOM_BIG = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/room/big/room_big_1"), BiomeMakeover.ID("mansion/room/big/room_big_2"), BiomeMakeover.ID("mansion/room/big/room_big_3"), BiomeMakeover.ID("mansion/room/big/room_big_4"), BiomeMakeover.ID("mansion/room/big/room_big_5"), BiomeMakeover.ID("mansion/room/big/room_big_6"), BiomeMakeover.ID("mansion/room/big/room_big_7"), BiomeMakeover.ID("mansion/room/big/room_big_8"), BiomeMakeover.ID("mansion/room/big/room_big_9"), BiomeMakeover.ID("mansion/room/big/room_big_10"), BiomeMakeover.ID("mansion/room/big/room_big_11")});
    public static List<ResourceLocation> STAIR_UP = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/stairs/up/stairs_up_1"), BiomeMakeover.ID("mansion/stairs/up/stairs_up_2")});
    public static List<ResourceLocation> STAIR_DOWN = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/stairs/down/stairs_down_1"), BiomeMakeover.ID("mansion/stairs/down/stairs_down_2")});
    public static List<ResourceLocation> INNER_WALL = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/wall/inner/wall_1"), BiomeMakeover.ID("mansion/wall/inner/wall_2"), BiomeMakeover.ID("mansion/wall/inner/wall_3"), BiomeMakeover.ID("mansion/wall/inner/wall_4"), BiomeMakeover.ID("mansion/wall/inner/wall_5"), BiomeMakeover.ID("mansion/wall/inner/wall_6"), BiomeMakeover.ID("mansion/wall/inner/wall_7"), BiomeMakeover.ID("mansion/wall/inner/wall_8"), BiomeMakeover.ID("mansion/wall/inner/wall_9")});
    public static List<ResourceLocation> FLAT_WALL = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/wall/flat/wall_flat_1")});
    public static List<ResourceLocation> OUTER_WALL_BASE = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_2"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_3"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_4"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_5"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_6"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_7")});
    public static List<ResourceLocation> OUTER_WALL = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/wall/outer/wall_outer_2"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_3"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_4"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_5"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_6")});
    public static List<ResourceLocation> OUTER_WINDOW = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/wall/outer/window/wall_window_1"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_2"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_3"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_4"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_5"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_6"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_7"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_8"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_9"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_10")});
    public static List<ResourceLocation> GARDEN = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/garden/garden_1"), BiomeMakeover.ID("mansion/garden/garden_2"), BiomeMakeover.ID("mansion/garden/garden_3"), BiomeMakeover.ID("mansion/garden/garden_4"), BiomeMakeover.ID("mansion/garden/garden_5"), BiomeMakeover.ID("mansion/garden/garden_6"), BiomeMakeover.ID("mansion/garden/garden_7")});
    public static List<ResourceLocation> TOWER_BASE = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/tower/base/tower_base_1")});
    public static List<ResourceLocation> TOWER_MID = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/tower/mid/tower_middle_1")});
    public static List<ResourceLocation> TOWER_TOP = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/tower/top/tower_top_1")});
    public static List<ResourceLocation> ROOF_0 = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_0_1"), BiomeMakeover.ID("mansion/roof/roof_0_2"), BiomeMakeover.ID("mansion/roof/roof_0_3"), BiomeMakeover.ID("mansion/roof/roof_0_4")});
    public static List<ResourceLocation> ROOF_1 = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_1_1"), BiomeMakeover.ID("mansion/roof/roof_1_2"), BiomeMakeover.ID("mansion/roof/roof_1_3")});
    public static List<ResourceLocation> ROOF_2 = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_2_1"), BiomeMakeover.ID("mansion/roof/roof_2_2")});
    public static List<ResourceLocation> ROOF_2_STRAIGHT = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_2_straight_1"), BiomeMakeover.ID("mansion/roof/roof_2_straight_2")});
    public static List<ResourceLocation> ROOF_3 = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_3_1"), BiomeMakeover.ID("mansion/roof/roof_3_2"), BiomeMakeover.ID("mansion/roof/roof_3_3")});
    public static List<ResourceLocation> ROOF_4 = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_4_1"), BiomeMakeover.ID("mansion/roof/roof_4_2"), BiomeMakeover.ID("mansion/roof/roof_4_3"), BiomeMakeover.ID("mansion/roof/roof_4_4")});
    public static List<ResourceLocation> ROOF_SPLIT = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/roof/roof_split_1"), BiomeMakeover.ID("mansion/roof/roof_split_2"), BiomeMakeover.ID("mansion/roof/roof_split_3"), BiomeMakeover.ID("mansion/roof/roof_split_4"), BiomeMakeover.ID("mansion/roof/roof_split_5")});
    public static List<ResourceLocation> DUNGEON_DOOR = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/dungeon/door_1"), BiomeMakeover.ID("mansion/dungeon/door_2"), BiomeMakeover.ID("mansion/dungeon/door_3"), BiomeMakeover.ID("mansion/dungeon/door_4"), BiomeMakeover.ID("mansion/dungeon/door_5"), BiomeMakeover.ID("mansion/dungeon/door_6"), BiomeMakeover.ID("mansion/dungeon/door_7")});
    public static List<ResourceLocation> DUNGEON_WALL = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/dungeon/wall_1")});
    public static List<ResourceLocation> DUNGEON_ROOM = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/dungeon/room_1"), BiomeMakeover.ID("mansion/dungeon/room_2"), BiomeMakeover.ID("mansion/dungeon/room_3"), BiomeMakeover.ID("mansion/dungeon/room_4"), BiomeMakeover.ID("mansion/dungeon/room_5"), BiomeMakeover.ID("mansion/dungeon/room_6"), BiomeMakeover.ID("mansion/dungeon/room_7"), BiomeMakeover.ID("mansion/dungeon/room_8"), BiomeMakeover.ID("mansion/dungeon/room_9"), BiomeMakeover.ID("mansion/dungeon/room_10"), BiomeMakeover.ID("mansion/dungeon/room_11"), BiomeMakeover.ID("mansion/dungeon/room_12"), BiomeMakeover.ID("mansion/dungeon/room_13"), BiomeMakeover.ID("mansion/dungeon/room_14"), BiomeMakeover.ID("mansion/dungeon/room_15"), BiomeMakeover.ID("mansion/dungeon/room_16"), BiomeMakeover.ID("mansion/dungeon/room_17"), BiomeMakeover.ID("mansion/dungeon/room_18")});
    public static List<ResourceLocation> DUNGEON_STAIR_BOTTOM = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/dungeon/stair_bottom")});
    public static List<ResourceLocation> DUNGEON_STAIR_MID = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/dungeon/stair_mid_1"), BiomeMakeover.ID("mansion/dungeon/stair_mid_2")});
    public static List<ResourceLocation> DUNGEON_STAIR_TOP = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/dungeon/stair_top")});
    public static List<ResourceLocation> BOSS_ROOM = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/boss_room")});
    public static List<ResourceLocation> ENTRANCE = Lists.newArrayList((Object[])new ResourceLocation[]{BiomeMakeover.ID("mansion/entrance/entrance_1")});
    public static final ResourceLocation CORNER_FILLER = BiomeMakeover.ID("mansion/corner_filler");
    public static final ResourceLocation EMPTY = BiomeMakeover.ID("mansion/empty");
    private static final EntityType[] enemies = new EntityType[]{EntityType.f_20493_, EntityType.f_20568_, EntityType.f_20513_};
    private static final EntityType[] ranged_enemies = new EntityType[]{EntityType.f_20513_};
    private static final EntityType[] golem_enemies = new EntityType[]{(EntityType)BMEntities.STONE_GOLEM.get()};
    private static final EntityType[] ravagers = new EntityType[]{EntityType.f_20518_};
    private static final EntityType[] cow = new EntityType[]{EntityType.f_20557_};
    private static final BlockState[] SHROOMS = new BlockState[]{Blocks.f_50073_.m_49966_(), Blocks.f_50072_.m_49966_(), BMBlocks.WILD_MUSHROOMS.get().m_49966_()};

    public MansionFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), MansionFeature::generatePieces));
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static <C extends FeatureConfiguration> void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<C> ctx) {
        MansionLayout layout = new MansionLayout();
        ChunkPos chunkPos = ctx.f_192705_();
        ChunkGenerator chunkGenerator = ctx.f_192703_();
        LevelHeightAccessor levelHeightAccessor = ctx.f_192707_();
        WorldgenRandom random = ctx.f_192708_();
        int x = chunkPos.f_45578_ * 16;
        int z = chunkPos.f_45579_ * 16;
        BlockPos pos = new BlockPos(x, chunkGenerator.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor), z);
        layout.generateLayout((Random)random, pos.m_123342_());
        Grid<MansionRoom> roomGrid = layout.getLayout();
        Collection sortedRooms = roomGrid.getEntries();
        sortedRooms = sortedRooms.stream().sorted(Comparator.comparingInt(MansionRoom::getSortValue)).collect(Collectors.toList());
        sortedRooms.forEach(arg_0 -> MansionFeature.lambda$generatePieces$0(pos, (Random)random, builder, ctx, roomGrid, arg_0));
    }

    private static /* synthetic */ void lambda$generatePieces$0(BlockPos pos, Random random, StructurePiecesBuilder builder, PieceGenerator.Context ctx, Grid roomGrid, MansionRoom rm) {
        int xx = pos.m_123341_() + rm.getPosition().m_123341_() * 12;
        int yy = pos.m_123342_() + rm.getPosition().m_123342_() * 7;
        int zz = pos.m_123343_() + rm.getPosition().m_123343_() * 12;
        BlockPos offsetPos = new BlockPos(xx, yy, zz);
        Rotation rotation = rm.getRotation(random);
        offsetPos = rm.getOffsetForRotation(offsetPos, rotation);
        boolean ground = rm.getPosition().m_123342_() == 0;
        ResourceLocation template = rm.getTemplate(random);
        builder.m_142679_((StructurePiece)new Piece(ctx.f_192704_(), template.toString(), offsetPos, rotation, ground, rm.getRoomType() == RoomType.TOWER_MID || rm.getRoomType() == RoomType.TOWER_TOP));
        BlockPos wallPos = new BlockPos(xx, yy, zz);
        rm.addWalls(random, wallPos, ctx.f_192704_(), roomGrid, builder);
    }

    public static class Piece
    extends TemplateStructurePiece
    implements DirectionalDataHandler {
        private final boolean ground;
        private final boolean isWall;

        public Piece(StructureManager structureManager, String string, BlockPos blockPos, Rotation rotation, boolean needsGroundAdjustment, boolean isWall) {
            super(BMWorldGen.DarkForest.MANSION_PIECE, 0, structureManager, new ResourceLocation(string), string, Piece.makeSettings(rotation, isWall), blockPos);
            this.ground = needsGroundAdjustment;
            this.isWall = isWall;
        }

        public Piece(StructureManager structureManager, CompoundTag compoundTag) {
            super(BMWorldGen.DarkForest.MANSION_PIECE, compoundTag, structureManager, resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rotation")), compoundTag.m_128471_("IsWall")));
            this.ground = compoundTag.m_128471_("Ground");
            this.isWall = compoundTag.m_128471_("IsWall");
        }

        public Piece(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
            this(ctx.f_192764_(), compoundTag);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, boolean isWall) {
            return new StructurePlaceSettings().m_74392_(true).m_163782_(false).m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)(isWall ? IGNORE_AIR_AND_STRUCTURE_BLOCKS : IGNORE_STRUCTURE_BLOCKS));
        }

        protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            super.m_183620_(structurePieceSerializationContext, compoundTag);
            compoundTag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
            compoundTag.m_128379_("Ground", this.ground);
            compoundTag.m_128379_("IsWall", this.isWall);
        }

        protected void m_7756_(String metadata, BlockPos pos, ServerLevelAccessor level, Random random, BoundingBox boundingBox) {
            if (metadata.equals("boss")) {
                this.spawnBoss(level, pos);
            } else if (metadata.equals("arena_pos")) {
                level.m_7731_(pos, Blocks.f_50472_.m_49966_(), 2);
            }
        }

        private void spawnBoss(ServerLevelAccessor level, BlockPos pos) {
            AdjudicatorEntity boss = (AdjudicatorEntity)((EntityType)BMEntities.ADJUDICATOR.get()).m_20615_((Level)level.m_6018_());
            boss.m_21530_();
            boss.m_20035_(pos, 0.0f, 0.0f);
            boss.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            level.m_47205_((Entity)boss);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        }

        @Override
        public void handleDirectionalMetadata(String meta, Direction dir, BlockPos pos, WorldGenLevel world, Random random) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            BlockPos offsetPos = pos.m_142300_(dir);
            BlockState offsetState = world.m_8055_(offsetPos);
            switch (meta) {
                case "ivy": {
                    this.generateIvy(dir, pos, world, random);
                    break;
                }
                case "tapestry": {
                    this.generateTapestry(dir, pos, world, random);
                    break;
                }
                case "bonemeal": {
                    break;
                }
                case "spawner_spiders": {
                    BlockEntity be;
                    if (offsetState.m_60734_() != Blocks.f_50085_ || !((be = world.m_7702_(offsetPos)) instanceof SpawnerBlockEntity)) break;
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)be;
                    spawner.m_59801_().m_45462_(RandomUtil.choose(EntityType.f_20554_, EntityType.f_20479_));
                    be.m_6596_();
                    break;
                }
                case "owl": {
                    OwlEntity e = (OwlEntity)((EntityType)BMEntities.OWL.get()).m_20615_((Level)world.m_6018_());
                    e.m_20035_(pos, 0.0f, 0.0f);
                    if (random.nextFloat() < 0.25f) {
                        Stuntable.setStunted((AgeableMob)e, true);
                    }
                    world.m_47205_((Entity)e);
                    break;
                }
                case "shroom": {
                    world.m_7731_(pos, RandomUtil.choose(SHROOMS), 3);
                }
            }
            if (meta.startsWith("loot")) {
                String[] splits = meta.split("_");
                String table = splits[1];
                int chance = splits.length < 3 ? 100 : Integer.parseInt(splits[2]);
                BlockState setState = null;
                if (splits.length >= 4) {
                    StringBuilder name = new StringBuilder();
                    for (int i = 3; i < splits.length; ++i) {
                        name.append(splits[i]).append("_");
                    }
                    setState = ((Block)Registry.f_122824_.m_7745_(new ResourceLocation(name.substring(0, name.length() - 1)))).m_49966_();
                }
                if (random.nextInt(100) <= chance) {
                    ResourceLocation tableID = null;
                    switch (table) {
                        case "arrow": {
                            tableID = LOOT_ARROW;
                            break;
                        }
                        case "dungeonjunk": {
                            tableID = LOOT_DUNGEON_JUNK;
                            break;
                        }
                        case "dungeon": {
                            tableID = LOOT_DUNGEON_STANDARD;
                            break;
                        }
                        case "dungeongood": {
                            tableID = LOOT_DUNGEON_GOOD;
                            break;
                        }
                        case "junk": {
                            tableID = LOOT_JUNK;
                            break;
                        }
                        case "standard": 
                        case "common": {
                            tableID = LOOT_STANDARD;
                            break;
                        }
                        case "loot_good": 
                        case "good": {
                            tableID = LOOT_GOOD;
                            break;
                        }
                        default: {
                            System.out.println(table);
                        }
                    }
                    BlockEntity be = world.m_7702_(offsetPos);
                    if (be instanceof RandomizableContainerBlockEntity) {
                        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)be;
                        container.m_59626_(tableID, random.nextLong());
                    }
                } else {
                    world.m_7731_(offsetPos, Blocks.f_50016_.m_49966_(), 3);
                }
                if (setState != null) {
                    world.m_7731_(pos, setState, 3);
                }
            } else if (meta.startsWith("enemy")) {
                this.handleSpawning(meta, world, pos, enemies);
            } else if (meta.startsWith("ranger")) {
                this.handleSpawning(meta, world, pos, ranged_enemies);
            } else if (meta.startsWith("golem")) {
                this.handleSpawning(meta, world, pos, new EntityType[]{(EntityType)BMEntities.STONE_GOLEM.get()});
            } else if (meta.startsWith("ravager")) {
                this.handleSpawning(meta, world, pos, ravagers);
            } else if (meta.startsWith("cow")) {
                this.handleSpawning(meta, world, pos, cow);
            }
        }

        private void handleSpawning(String meta, WorldGenLevel world, BlockPos pos, EntityType<?>[] pool) {
            int chance;
            String[] splits = meta.split("_");
            if (splits.length < 2) {
                chance = 100;
            } else {
                chance = Integer.parseInt(splits[1]);
                chance /= 2;
            }
            if (world.m_5822_().nextInt(100) <= chance) {
                EntityType<?> type = RandomUtil.choose(pool);
                Entity e = type.m_20615_((Level)world.m_6018_());
                if (e == null) {
                    return;
                }
                e.m_20035_(pos, 0.0f, 0.0f);
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                    mob.m_21530_();
                }
                world.m_47205_(e);
            }
        }

        private void doBonemealEffect(WorldGenLevel level, BlockPos pos, Random random) {
            BlockPos blockPos = pos.m_7494_();
            BlockState blockState = Blocks.f_50034_.m_49966_();
            for (int i = 0; i < 128; ++i) {
                BlockPos placePos = blockPos;
                for (int j = 0; j < i / 16; ++j) {
                    if (level.m_8055_((placePos = placePos.m_142082_(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).m_7495_()).m_60713_(Blocks.f_50440_) && !level.m_8055_(placePos).m_60838_((BlockGetter)level, placePos)) continue;
                }
                BlockPos blockPos2 = blockPos.m_7494_();
                BlockState blockState2 = Blocks.f_50034_.m_49966_();
                block2: for (int l = 0; l < 128; ++l) {
                    BlockPos blockPos3 = blockPos2;
                    for (int j = 0; j < l / 16; ++j) {
                        if (!level.m_8055_((blockPos3 = blockPos3.m_142082_(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).m_7495_()).m_60713_(Blocks.f_50440_) || level.m_8055_(blockPos3).m_60838_((BlockGetter)level, blockPos3)) continue block2;
                    }
                    BlockState blockState3 = level.m_8055_(blockPos3);
                    if (!blockState3.m_60713_(blockState2.m_60734_()) || random.nextInt(10) == 0) {
                        // empty if block
                    }
                    if (!blockState3.m_60795_()) continue;
                    if (random.nextInt(8) == 0) {
                        List list = ((Biome)level.m_204166_(blockPos3).m_203334_()).m_47536_().m_47815_();
                        if (list.isEmpty()) continue;
                        Holder holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
                        continue;
                    }
                    Holder holder = VegetationPlacements.f_195459_;
                }
            }
        }

        private void generateTapestry(Direction dir, BlockPos pos, WorldGenLevel world, Random random) {
            if (dir == Direction.DOWN || dir == Direction.UP) {
                Block tapestryBlock = RandomUtil.choose(BMBlocks.TAPESTRY_FLOOR_BLOCKS).get();
                world.m_7731_(pos, (BlockState)tapestryBlock.m_49966_().m_61124_((Property)AbstractTapestryBlock.ROTATION, (Comparable)Integer.valueOf(Rotation.m_55956_((Random)random).ordinal())), 3);
            } else {
                Block tapestryBlock = RandomUtil.choose(BMBlocks.TAPESTRY_WALL_BLOCKS).get();
                world.m_7731_(pos, (BlockState)tapestryBlock.m_49966_().m_61124_((Property)AbstractTapestryWallBlock.FACING, (Comparable)dir.m_122424_()), 3);
            }
        }

        private void generateIvy(Direction dir, BlockPos pos, WorldGenLevel world, Random random) {
            BlockPos endPos;
            BlockPos startPos;
            if (random.nextFloat() < 0.25f) {
                return;
            }
            BlockPos topPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos.m_5484_(dir.m_122424_(), 2)).m_7495_();
            BlockState topState = world.m_8055_(topPos);
            if (topState.m_60713_(BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodTypeInfo.Type.SLAB).get()) || topState.m_60713_(BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodTypeInfo.Type.STAIR).get())) {
                return;
            }
            int size = 3;
            if (dir.m_122430_() == 0) {
                Direction rot1 = dir.m_122427_();
                Direction rot2 = dir.m_122428_();
                startPos = pos.m_5484_(rot1, size).m_5484_(Direction.UP, size);
                endPos = pos.m_5484_(rot2, size).m_5484_(Direction.DOWN, size);
            } else {
                startPos = pos.m_142082_(-size, 0, -size);
                endPos = pos.m_142082_(size, 0, size);
            }
            BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos).forEach(p -> {
                BlockPos onPos;
                BlockState onState;
                BlockState currentState = world.m_8055_(p);
                if (random.nextFloat() <= 0.25f && (currentState.m_60795_() || currentState.m_60713_(BMBlocks.IVY.get())) && (onState = world.m_8055_(onPos = p.m_142300_(dir))).m_60783_((BlockGetter)world, onPos, dir.m_122424_())) {
                    if (currentState.m_60713_(BMBlocks.IVY.get())) {
                        world.m_7731_(p, (BlockState)currentState.m_61124_((Property)IvyBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        world.m_7731_(p, (BlockState)BMBlocks.IVY.get().m_49966_().m_61124_((Property)IvyBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(true)), 3);
                    }
                }
            });
        }

        public boolean doesModifyGround() {
            return this.ground;
        }
    }
}

