/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import party.lemons.biomemakeover.block.IlluniteClusterBlock;
import party.lemons.biomemakeover.init.BMBlocks;

public class MesmeriteBoulderFeature
extends Feature<BlockStateConfiguration> {
    public MesmeriteBoulderFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> ctx) {
        BlockState block;
        BlockPos blockPos = ctx.m_159777_();
        Random random = ctx.m_159776_();
        WorldGenLevel level = ctx.m_159774_();
        while (blockPos.m_123342_() > 3 && (level.m_46859_(blockPos.m_7495_()) || !MesmeriteBoulderFeature.m_159759_((BlockState)(block = level.m_8055_(blockPos.m_7495_()))) && !MesmeriteBoulderFeature.m_159747_((BlockState)block))) {
            blockPos = blockPos.m_7495_();
        }
        if (blockPos.m_123342_() <= 3) {
            return false;
        }
        ArrayList rockPositions = Lists.newArrayList();
        for (int i = 0; i < 4; ++i) {
            int xSize = random.nextInt(3);
            int ySize = random.nextInt(4);
            int zSize = random.nextInt(3);
            float distance = (float)(xSize + ySize + zSize) * 0.333f + 0.5f;
            for (BlockPos genPos : BlockPos.m_121940_((BlockPos)blockPos.m_142082_(-xSize, -ySize, -zSize), (BlockPos)blockPos.m_142082_(xSize, ySize, zSize))) {
                int maxAttempts;
                if (!(genPos.m_123331_((Vec3i)blockPos) <= (double)(distance * distance))) continue;
                BlockPos placePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, genPos);
                BlockState belowState = level.m_8055_(placePos.m_7495_());
                for (maxAttempts = 100; maxAttempts > 0 && (belowState.m_60767_().m_76336_() || belowState.m_204336_(BlockTags.f_13106_) || belowState.m_204336_(BlockTags.f_13035_)); --maxAttempts) {
                    placePos = placePos.m_7495_();
                    belowState = level.m_8055_(placePos.m_7495_());
                }
                if (maxAttempts <= 0) {
                    return false;
                }
                if (!belowState.m_60713_(BMBlocks.MESMERITE.get()) && !MesmeriteBoulderFeature.m_159759_((BlockState)belowState) && !MesmeriteBoulderFeature.m_159747_((BlockState)belowState) && belowState.m_60734_() != Blocks.f_49994_) continue;
                level.m_7731_(placePos, ((BlockStateConfiguration)ctx.m_159778_()).f_67547_, 4);
                rockPositions.add(placePos);
            }
            blockPos = blockPos.m_142082_(-1 + random.nextInt(2), -random.nextInt(2), -1 + random.nextInt(2));
        }
        for (BlockPos placePositions : rockPositions) {
            if (random.nextInt(10) != 0) continue;
            for (Direction direction : Direction.values()) {
                BlockPos offsetPos = placePositions.m_142300_(direction);
                if (!level.m_46859_(offsetPos) || !random.nextBoolean()) continue;
                level.m_7731_(offsetPos, (BlockState)BMBlocks.ILLUNITE_CLUSTER.get().m_49966_().m_61124_((Property)IlluniteClusterBlock.f_152006_, (Comparable)direction), 16);
            }
        }
        return true;
    }
}

