/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.StructureSets;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.apache.commons.lang3.tuple.Pair;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.SmallLilyPadBlock;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.biomemakeover.level.feature.GhostTownFeature;
import party.lemons.biomemakeover.level.feature.SunkenRuinFeature;
import party.lemons.biomemakeover.level.feature.foliage.AncientOakTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.BalsaTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.CypressTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.HangingLeavesDecorator;
import party.lemons.biomemakeover.level.feature.foliage.IvyDecorator;
import party.lemons.biomemakeover.level.feature.foliage.WillowFoliagePlacer;
import party.lemons.biomemakeover.level.feature.foliage.WillowingBranchDecorator;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.generate.foliage.WillowTrunkPlacer;
import party.lemons.biomemakeover.mixin.TrunkPlacerTypeInvoker;
import party.lemons.biomemakeover.util.registry.RegistryHelper;
import party.lemons.biomemakeover.util.registry.WoodTypeInfo;

public class BMWorldGen {
    private static final List<Pair<ResourceLocation, ConfiguredFeature>> CFG_FEATURES = Lists.newArrayList();
    private static final List<Pair<ResourceLocation, PlacedFeature>> PL_FEATURES = Lists.newArrayList();
    private static boolean registered = false;
    public static Map<GenerationStep.Decoration, List<Holder<PlacedFeature>>> MUSHROOM_GEN = Maps.newHashMap();
    public static List<ConfiguredWorldCarver> MUSHROOM_CARVERS = Lists.newArrayList();
    public static Map<GenerationStep.Decoration, List<Holder<PlacedFeature>>> BADLANDS_GEN = Maps.newHashMap();
    public static List<ConfiguredStructureFeature<?, ?>> BADLANDS_STRUCTURES = Lists.newArrayList();
    public static Map<GenerationStep.Decoration, List<Holder<PlacedFeature>>> SWAMP_GEN = Maps.newHashMap();
    public static List<ConfiguredStructureFeature<?, ?>> SWAMP_STRUCTURES = Lists.newArrayList();
    public static Map<GenerationStep.Decoration, List<Holder<PlacedFeature>>> DF_GEN = Maps.newHashMap();
    public static List<ConfiguredStructureFeature<?, ?>> DF_STRUCTURES = Lists.newArrayList();

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        MushroomFields.init();
        Badlands.init();
        Swamp.init();
        DarkForest.init();
        BMWorldGen.registerStuff();
    }

    public static void registerStuff() {
        for (Pair<ResourceLocation, ConfiguredFeature> pair : CFG_FEATURES) {
            Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)((ResourceLocation)pair.getLeft()), (Object)((ConfiguredFeature)pair.getRight()));
        }
        for (Pair<ResourceLocation, ConfiguredFeature> pair : PL_FEATURES) {
            Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)((ResourceLocation)pair.getLeft()), (Object)((PlacedFeature)pair.getRight()));
        }
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> configure(String id, F feature, FC featureConfiguration) {
        return BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)("biomemakeover:" + id), (Object)new ConfiguredFeature(feature, featureConfiguration));
    }

    public static Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> configure(String string, Feature<NoneFeatureConfiguration> feature) {
        return BMWorldGen.configure(string, feature, FeatureConfiguration.f_67737_);
    }

    public static Holder<PlacedFeature> place(String string, Holder<? extends ConfiguredFeature<?, ?>> holder, List<PlacementModifier> list) {
        return BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)("biomemakeover:" + string), (Object)new PlacedFeature(Holder.m_205706_(holder), List.copyOf(list)));
    }

    public static Holder<PlacedFeature> place(String string, Holder<? extends ConfiguredFeature<?, ?>> holder, PlacementModifier ... placementModifiers) {
        return BMWorldGen.place(string, holder, List.of(placementModifiers));
    }

    public static final class MushroomFields {
        private static final int UG_START = 60;
        private static final int UG_END = -30;
        private static final HeightRangePlacement UG_HEIGHT = HeightRangePlacement.m_191683_((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)-30), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)));
        public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> UNDERGROUND_MYCELIUM_VEGETATION = BMWorldGen.configure("underground_mycelium_vegetation", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)BMBlocks.MYCELIUM_SPROUTS.get().m_49966_(), 50).m_146271_((Object)BMBlocks.MYCELIUM_ROOTS.get().m_49966_(), 30).m_146271_((Object)Blocks.f_50073_.m_49966_(), 10).m_146271_((Object)Blocks.f_50072_.m_49966_(), 10).m_146271_((Object)BMBlocks.GREEN_GLOWSHROOM.get().m_49966_(), 1).m_146271_((Object)BMBlocks.PURPLE_GLOWSHROOM.get().m_49966_(), 1).m_146271_((Object)BMBlocks.TALL_BROWN_MUSHROOM.get().m_49966_(), 3).m_146271_((Object)BMBlocks.TALL_RED_MUSHROOM.get().m_49966_(), 3))));
        public static final VegetationPatchConfiguration UNDERGROUND_MYCELIUM_CONFIG = new VegetationPatchConfiguration(BMBlocks.ORE_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50195_), BMWorldGen.place("underground_mycelium_vegetation", UNDERGROUND_MYCELIUM_VEGETATION, new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)UniformInt.m_146622_((int)1, (int)3), 0.25f, 3, 0.1f, (IntProvider)UniformInt.m_146622_((int)7, (int)12), 0.8f);
        public static final Holder<ConfiguredFeature<VegetationPatchConfiguration, ?>> UNDERGROUND_MYCELIUM = BMWorldGen.configure("underground_mycelium", BMFeatures.GRASS_PATCH.get(), UNDERGROUND_MYCELIUM_CONFIG);
        public static final Holder<PlacedFeature> UNDERGROUND_MYCELIUM_PLACED = BMWorldGen.place("underground_mycelium", UNDERGROUND_MYCELIUM, new PlacementModifier[]{CountPlacement.m_191628_((int)12), InSquarePlacement.m_191715_(), UG_HEIGHT, EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> LICHEN_BLOCK = BMWorldGen.configure("lichen", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)Blocks.f_152475_.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)Direction.UP), (Comparable)Boolean.valueOf(true))))));
        public static final VegetationPatchConfiguration UNDERGROUND_LICHEN_CONFIG = new VegetationPatchConfiguration(BlockTags.f_144266_, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50069_), BMWorldGen.place("lichen", LICHEN_BLOCK, new PlacementModifier[0]), CaveSurface.CEILING, (IntProvider)UniformInt.m_146622_((int)1, (int)1), 0.0f, 1, 0.6f, (IntProvider)UniformInt.m_146622_((int)4, (int)6), 0.0f);
        public static final Holder<ConfiguredFeature<VegetationPatchConfiguration, ?>> UNDERGROUND_LICHEN = BMWorldGen.configure("undergroud_lichen", Feature.f_159734_, UNDERGROUND_LICHEN_CONFIG);
        public static final Holder<PlacedFeature> UNDERGROUND_LICHEN_PLACED = BMWorldGen.place("underground_lichen", UNDERGROUND_LICHEN, new PlacementModifier[]{CountPlacement.m_191628_((int)100), InSquarePlacement.m_191715_(), UG_HEIGHT, EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_()});
        public static final RandomPatchConfiguration MUSHROOM_SPROUTS_CONFIG = FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.MYCELIUM_SPROUTS.get())), List.of(), (int)9);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> MUSHROOM_FIELD_SPROUTS = BMWorldGen.configure("mushroom_field_sprouts", Feature.f_65763_, MUSHROOM_SPROUTS_CONFIG);
        public static final Holder<PlacedFeature> SPROUTS_PLACED = BMWorldGen.place("mushroom_field_sprouts", MUSHROOM_FIELD_SPROUTS, new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RandomPatchConfiguration MUSHROOM_ROOTS_CONFIG = FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.MYCELIUM_ROOTS.get())), List.of(), (int)5);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> MUSHROOM_FIELD_ROOTS = BMWorldGen.configure("mushroom_roots", Feature.f_65763_, MUSHROOM_ROOTS_CONFIG);
        public static final Holder<PlacedFeature> ROOTS_PLACED = BMWorldGen.place("mushroom_roots", MUSHROOM_FIELD_ROOTS, new PlacementModifier[]{CountPlacement.m_191628_((int)7), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final Holder<PlacedFeature> UNDERGROUND_HUGE_BROWN_SHROOM_PLACED = BMWorldGen.place("ug_huge_brown_shroom", TreeFeatures.f_195121_, new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), UG_HEIGHT});
        public static final Holder<PlacedFeature> UNDERGROUND_HUGE_RED_SHROOM_PLACED = BMWorldGen.place("ug_huge_red_shroom", TreeFeatures.f_195122_, new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), UG_HEIGHT});
        public static final Holder<ConfiguredFeature<HugeMushroomFeatureConfiguration, ?>> HUGE_PURPLE_GLOWSHROOM = BMWorldGen.configure("huge_purple_shroom", BMFeatures.HUGE_PURPLE_GLOWSHROOM_CONFIG.get(), new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.PURPLE_GLOWSHROOM_BLOCK.get()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.GLOWSHROOM_STEM.get()), 1));
        public static final Holder<PlacedFeature> HUGE_PURPLE_GLOWSHROOM_PLACED = BMWorldGen.place("huge_pruple_shroom", HUGE_PURPLE_GLOWSHROOM, new PlacementModifier[0]);
        public static final Holder<ConfiguredFeature<HugeMushroomFeatureConfiguration, ?>> HUGE_GREEN_GLOWSHROOM = BMWorldGen.configure("huge_green_shroom", BMFeatures.HUGE_GREEN_GLOWSHROOM_CONFIG.get(), new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.GREEN_GLOWSHROOM_BLOCK.get()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.GLOWSHROOM_STEM.get()), 1));
        public static final Holder<PlacedFeature> HUGE_GREEN_GLOWSHROOM_PLACED = BMWorldGen.place("huge_green_shroom", HUGE_GREEN_GLOWSHROOM, new PlacementModifier[0]);
        public static final Holder<ConfiguredFeature<RandomBooleanFeatureConfiguration, ?>> UNDERGROUND_GLOWSHROOMS = BMWorldGen.configure("underground_glowshrooms", Feature.f_65756_, new RandomBooleanFeatureConfiguration(HUGE_GREEN_GLOWSHROOM_PLACED, HUGE_PURPLE_GLOWSHROOM_PLACED));
        public static final Holder<PlacedFeature> UNDERGROUND_GLOWSHROOMS_PLACED = BMWorldGen.place("underground_glowshrooms", UNDERGROUND_GLOWSHROOMS, new PlacementModifier[]{CountPlacement.m_191628_((int)120), InSquarePlacement.m_191715_(), UG_HEIGHT});
        public static final Holder<ConfiguredFeature<HugeMushroomFeatureConfiguration, ?>> HUGE_ORANGE_GLOWSHROOM = BMWorldGen.configure("huge_orange_shroom", BMFeatures.HUGE_ORANGE_GLOWSHROOM_FEATURE.get(), new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.ORANGE_GLOWSHROOM_BLOCK.get()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.GLOWSHROOM_STEM.get()), 1));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> GREEN_GLOWSHROOM = BMWorldGen.configure("green_glowshrooms", Feature.f_65763_, FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.GREEN_GLOWSHROOM.get()))));
        public static final Holder<PlacedFeature> GREEN_GLOWSHROOM_PLACED = BMWorldGen.place("green_glowshroom", GREEN_GLOWSHROOM, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), UG_HEIGHT});
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PURPLE_GLOWSHROOM = BMWorldGen.configure("purple_glowshroom", Feature.f_65763_, FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.PURPLE_GLOWSHROOM.get()))));
        public static final Holder<PlacedFeature> PURPLE_GLOWSHROOM_PLACED = BMWorldGen.place("purple_glowshroom", PURPLE_GLOWSHROOM, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), UG_HEIGHT});
        public static final Holder<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> ORANGE_GLOWSHROOM = BMWorldGen.configure("orange_glowshroom", BMFeatures.ORANGE_GLOWSHROOM_FEATURE.get(), new ProbabilityFeatureConfiguration(0.1f));
        public static final Holder<PlacedFeature> ORANGE_GLOWSHROOM_PLACED = BMWorldGen.place("orange_glowshroom", ORANGE_GLOWSHROOM, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_});
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_BROWN_MUSHROOMS = BMWorldGen.configure("tall_brown_mushrooms", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.TALL_BROWN_MUSHROOM.get())), List.of(), (int)20));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_RED_MUSHROOMS = BMWorldGen.configure("tall_red_mushroom", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.TALL_RED_MUSHROOM.get())), List.of(), (int)20));
        public static final Holder<PlacedFeature> TALL_BROWN_MUSHROOMS_PLACED = BMWorldGen.place("tall_brown_mushrooms", TALL_BROWN_MUSHROOMS, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_});
        public static final Holder<PlacedFeature> TALL_RED_MUSHROOMS_PLACED = BMWorldGen.place("tall_red_mushrooms", TALL_RED_MUSHROOMS, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_});
        public static final TrunkPlacerType<BalsaTrunkPlacer> BLIGHTED_BALSA_TRUNK = TrunkPlacerTypeInvoker.callRegister(BiomeMakeover.ID("blighted_balse").toString(), BalsaTrunkPlacer.CODEC);
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> BLIGHTED_BALSA = BMWorldGen.configure("blighted_balsa", Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.BLIGHTED_BALSA_WOOD_INFO.getBlock(WoodTypeInfo.Type.LOG).get()), (TrunkPlacer)new BalsaTrunkPlacer(4, 6, 8), (BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.BLIGHTED_BALSA_LEAVES.get()), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)UniformInt.m_146622_((int)1, (int)1), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).m_68244_().m_68251_());
        public static final Holder<PlacedFeature> BLIGHTED_BALSA_CHECKED = BMWorldGen.place("blighted_balsa_checked", BLIGHTED_BALSA, new PlacementModifier[]{PlacementUtils.m_206493_((Block)BMBlocks.BLIGHTED_BALSA_SAPLING.get())});
        public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> BLIGHTED_BALSA_FILTERED = BMWorldGen.configure("blighted_balsa_filtered", Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(BLIGHTED_BALSA_CHECKED, 0.8f)), BLIGHTED_BALSA_CHECKED));
        public static final Holder<PlacedFeature> BLIGHTED_BALSA_TREES_PLACED = BMWorldGen.place("blighted_balsa_placed", BLIGHTED_BALSA_FILTERED, VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)12)));
        public static final ConfiguredWorldCarver<CaveCarverConfiguration> BIGGER_CAVES = WorldCarver.f_64974_.m_65063_((CarverConfiguration)new CaveCarverConfiguration(0.3f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)-30), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158930_((int)8), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50251_.m_49966_()), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)4.0f), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)4.0f), (FloatProvider)UniformFloat.m_146605_((float)-1.0f, (float)-0.4f)));

        public static void init() {
            Registry.m_122965_((Registry)BuiltinRegistries.f_123860_, (ResourceLocation)BiomeMakeover.ID("bigger_caves"), BIGGER_CAVES);
            RegistryHelper.gatherFields("biomemakeover", ConfiguredFeature.class, MushroomFields.class, CFG_FEATURES);
            RegistryHelper.gatherFields("biomemakeover", PlacedFeature.class, MushroomFields.class, PL_FEATURES);
            MUSHROOM_CARVERS.add(BIGGER_CAVES);
            MushroomFields.setFeatures();
        }

        public static void setFeatures() {
            MUSHROOM_GEN.put(GenerationStep.Decoration.UNDERGROUND_DECORATION, Lists.newArrayList((Object[])new Holder[]{UNDERGROUND_MYCELIUM_PLACED, UNDERGROUND_LICHEN_PLACED}));
            MUSHROOM_GEN.put(GenerationStep.Decoration.FLUID_SPRINGS, Lists.newArrayList((Object[])new Holder[]{BLIGHTED_BALSA_TREES_PLACED}));
            MUSHROOM_GEN.put(GenerationStep.Decoration.VEGETAL_DECORATION, Lists.newArrayList((Object[])new Holder[]{GREEN_GLOWSHROOM_PLACED, PURPLE_GLOWSHROOM_PLACED, ORANGE_GLOWSHROOM_PLACED, SPROUTS_PLACED, ROOTS_PLACED, UNDERGROUND_GLOWSHROOMS_PLACED, UNDERGROUND_HUGE_BROWN_SHROOM_PLACED, UNDERGROUND_HUGE_RED_SHROOM_PLACED, TALL_BROWN_MUSHROOMS_PLACED, TALL_RED_MUSHROOMS_PLACED, DarkForest.WILD_MUSHROOMS_PLACED}));
        }
    }

    public static final class Badlands {
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BARREL_CACTUS = BMWorldGen.configure("barrel_cactus", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)BMBlocks.BARREL_CACTUS.get().m_49966_(), 5).m_146271_((Object)BMBlocks.BARREL_CACTUS_FLOWERED.get().m_49966_(), 1))), List.of(), (int)20));
        public static final Holder<PlacedFeature> BARREL_CACTUS_PLACED = BMWorldGen.place("barrel_cactus", BARREL_CACTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_});
        public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> SAGUARO_CACTUS = BMWorldGen.configure("saguro_cactus", BMFeatures.SAGUARO_CACTUS_FEATURE.get());
        public static final Holder<PlacedFeature> SAGUARO_CACTUS_PLACED = BMWorldGen.place("saguaro_cactus", SAGUARO_CACTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_});
        public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> PAYDIRT = BMWorldGen.configure("paydirt", BMFeatures.PAYDIRT_FEATURE.get());
        public static final Holder<PlacedFeature> PAYDIRT_PLACED = BMWorldGen.place("paydirt", PAYDIRT, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> SURFACE_FOSSIL = BMWorldGen.configure("surface_fossil", BMFeatures.SURFACE_FOSSIL_FEATURE.get());
        public static final Holder<PlacedFeature> SURFACE_FOSSIL_PLACED = BMWorldGen.place("surface_fossil", SURFACE_FOSSIL, new PlacementModifier[]{RarityFilter.m_191900_((int)48), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final ConfiguredStructureFeature<?, ?> GHOST_TOWN_CONFIGURED = BMFeatures.GHOST_TOWN.get().m_209773_((FeatureConfiguration)GhostTownFeature.CONFIG, BiomeTags.f_207607_, true, Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, GhostTownFeature.SPAWNS)));

        public static void init() {
            GhostTownFeature.init();
            Holder townHolder = BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_123862_, (ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)BiomeMakeover.ID("ghost_town")), GHOST_TOWN_CONFIGURED);
            StructureSets.m_211131_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)BiomeMakeover.ID("ghost_town")), (Holder)townHolder, (StructurePlacement)new RandomSpreadStructurePlacement(32, 12, RandomSpreadType.LINEAR, 6969));
            RegistryHelper.gatherFields("biomemakeover", ConfiguredFeature.class, Badlands.class, CFG_FEATURES);
            RegistryHelper.gatherFields("biomemakeover", PlacedFeature.class, Badlands.class, PL_FEATURES);
            Badlands.setFeatures();
        }

        public static void setFeatures() {
            BADLANDS_GEN.put(GenerationStep.Decoration.VEGETAL_DECORATION, Lists.newArrayList((Object[])new Holder[]{BARREL_CACTUS_PLACED, SAGUARO_CACTUS_PLACED}));
            BADLANDS_GEN.put(GenerationStep.Decoration.UNDERGROUND_DECORATION, Lists.newArrayList((Object[])new Holder[]{PAYDIRT_PLACED}));
            BADLANDS_GEN.put(GenerationStep.Decoration.SURFACE_STRUCTURES, Lists.newArrayList((Object[])new Holder[]{SURFACE_FOSSIL_PLACED}));
            BADLANDS_STRUCTURES.add(GHOST_TOWN_CONFIGURED);
        }
    }

    public static final class Swamp {
        public static final TrunkPlacerType<CypressTrunkPlacer> CYPRESS_TRUNK = TrunkPlacerTypeInvoker.callRegister(BiomeMakeover.ID("swamp_cypress").toString(), CypressTrunkPlacer.CODEC);
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> SWAMP_CYPRESS = BMWorldGen.configure("swamp_cypress", BMFeatures.WATER_TREE.get(), new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.SWAMP_CYPRESS_WOOD_INFO.getBlock(WoodTypeInfo.Type.LOG).get()), (TrunkPlacer)new CypressTrunkPlacer(16, 3, 2), (BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.SWAMP_CYPRESS_LEAVES.get()), (FoliagePlacer)new WillowFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)2), 3, false), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1, OptionalInt.of(3))).m_68249_((List)ImmutableList.of((Object)((Object)new HangingLeavesDecorator((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.SWAMP_CYPRESS_LEAVES.get()))), (Object)new BeehiveDecorator(0.01f), (Object)new LeaveVineDecorator())).m_68244_().m_68251_());
        public static final Holder<PlacedFeature> SWAMP_CYPRESS_CHECKED = BMWorldGen.place("swamp_cypress_checked", SWAMP_CYPRESS, new PlacementModifier[]{PlacementUtils.m_206493_((Block)BMBlocks.SWAMP_CYPRESS_SAPLING.get())});
        public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> SWAMP_CYPRESS_FILTERED = BMWorldGen.configure("swamp_cypress_filtered", Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(SWAMP_CYPRESS_CHECKED, 0.8f)), SWAMP_CYPRESS_CHECKED));
        public static final Holder<PlacedFeature> SWAMP_CYPRESS_TREES_PLACED = BMWorldGen.place("swamp_cypress_trees_placed", SWAMP_CYPRESS_FILTERED, new PlacementModifier[]{InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)3), RarityFilter.m_191900_((int)2), PlacementUtils.m_195364_((int)4, (float)0.5f, (int)4), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final TrunkPlacerType<WillowTrunkPlacer> WILLOW_TRUNK = TrunkPlacerTypeInvoker.callRegister(BiomeMakeover.ID("willow").toString(), WillowTrunkPlacer.CODEC);
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> WILLOW = BMWorldGen.configure("willow", Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.WILLOW_WOOD_INFO.getBlock(WoodTypeInfo.Type.LOG).get()), (TrunkPlacer)new WillowTrunkPlacer(6, 3, 2), (BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.WILLOW_LEAVES.get()), (FoliagePlacer)new WillowFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)1), 3, false), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1, OptionalInt.of(3))).m_68249_((List)ImmutableList.of((Object)((Object)new HangingLeavesDecorator((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.WILLOW_LEAVES.get()))), (Object)((Object)WillowingBranchDecorator.INSTANCE), (Object)new BeehiveDecorator(0.02f))).m_68244_().m_68251_());
        public static final Holder<PlacedFeature> WILLOW_CHECKED = BMWorldGen.place("willow_checked", WILLOW, new PlacementModifier[]{PlacementUtils.m_206493_((Block)BMBlocks.WILLOW_SAPLING.get())});
        public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> WILLOW_FILTERED = BMWorldGen.configure("willow_filtered", Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(WILLOW_CHECKED, 0.8f)), WILLOW_CHECKED));
        public static final Holder<PlacedFeature> WILLOW_TREES_PLACED = BMWorldGen.place("willow_trees_placed", WILLOW_FILTERED, new PlacementModifier[]{InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)1), CountPlacement.m_191628_((int)4), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> PEAT = BMWorldGen.configure("peat", BMFeatures.PEAT_FEATURE.get());
        public static final Holder<PlacedFeature> PEAT_PLACED = BMWorldGen.place("peat", PEAT, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> REEDS = BMWorldGen.configure("reeds", BMFeatures.REED_FEATURE.get());
        public static final Holder<PlacedFeature> REEDS_PLACED = BMWorldGen.place("reeds", REEDS, new PlacementModifier[]{InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)10), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final Holder<PlacedFeature> SWAMP_HUGE_SHROOMS = BMWorldGen.place("swamp_huge_shrooms", VegetationFeatures.f_195172_, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.05f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SWAMP_AZALEA = BMWorldGen.configure("swamp_azalea", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.SWAMP_AZALEA.get())), List.of(), (int)12));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> MARIGOLD = BMWorldGen.configure("marigold", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.MARIGOLD.get())), List.of(), (int)12));
        public static final Holder<PlacedFeature> SWAMP_AZALEA_PLACED = BMWorldGen.place("swamp_azalea", SWAMP_AZALEA, new PlacementModifier[0]);
        public static final Holder<PlacedFeature> MARIGOLD_PLACED = BMWorldGen.place("marigold", MARIGOLD, new PlacementModifier[0]);
        public static final Holder<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> SWAMP_FLOWERS = BMWorldGen.configure("swamp_flowers", Feature.f_65755_, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205800_(List.of(SWAMP_AZALEA_PLACED, MARIGOLD_PLACED))));
        public static final Holder<PlacedFeature> SWAMP_FLOWERS_PLACED = BMWorldGen.place("swamp_flowers", SWAMP_FLOWERS, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, CountPlacement.m_191630_((IntProvider)ClampedInt.m_146395_((IntProvider)UniformInt.m_146622_((int)-3, (int)1), (int)0, (int)1)), BiomeFilter.m_191561_()});
        public static final WeightedStateProvider PADS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)BMBlocks.SMALL_LILY_PAD.get().m_49966_().m_61124_((Property)SmallLilyPadBlock.PADS, (Comparable)Integer.valueOf(1))), 1).m_146271_((Object)((BlockState)BMBlocks.SMALL_LILY_PAD.get().m_49966_().m_61124_((Property)SmallLilyPadBlock.PADS, (Comparable)Integer.valueOf(2))), 1).m_146271_((Object)((BlockState)BMBlocks.SMALL_LILY_PAD.get().m_49966_().m_61124_((Property)SmallLilyPadBlock.PADS, (Comparable)Integer.valueOf(3))), 1).m_146271_((Object)((BlockState)BMBlocks.SMALL_LILY_PAD.get().m_49966_().m_61124_((Property)SmallLilyPadBlock.PADS, (Comparable)Integer.valueOf(0))), 1).m_146271_((Object)BMBlocks.WATER_LILY.get().m_49966_(), 2));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_AND_FLOWERED_PADS = BMWorldGen.configure("small_and_flowered_pads", Feature.f_65763_, new RandomPatchConfiguration(10, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)PADS))));
        public static final Holder<PlacedFeature> LILY_PAD_PATCH_PLACED = BMWorldGen.place("small_and_flowered_pads", SMALL_AND_FLOWERED_PADS, VegetationPlacements.m_195474_((int)1));
        public static final ConfiguredStructureFeature<?, ?> SUNKEN_RUIN_CONFIGURED = BMFeatures.SUNKEN_RUIN.get().m_209762_((FeatureConfiguration)new SunkenRuinFeature.SunkenRuinFeatureConfig(0.8f, 0.6f), BiomeTags.f_207589_);
        public static final StructurePieceType SUNKEN_RUIN_PIECE = SunkenRuinFeature.SunkenRuinPiece::new;

        public static void init() {
            Holder ruinHolder = BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_123862_, (ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)BiomeMakeover.ID("sunken_ruin")), SUNKEN_RUIN_CONFIGURED);
            StructureSets.m_211131_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)BiomeMakeover.ID("sunken_ruin")), (Holder)ruinHolder, (StructurePlacement)new RandomSpreadStructurePlacement(24, 9, RandomSpreadType.LINEAR, 420));
            RegistryHelper.register("biomemakeover", Registry.f_122858_, FoliagePlacerType.class, Swamp.class, new RegistryHelper.RegistryCallback[0]);
            RegistryHelper.gatherFields("biomemakeover", ConfiguredFeature.class, Swamp.class, CFG_FEATURES);
            RegistryHelper.gatherFields("biomemakeover", PlacedFeature.class, Swamp.class, PL_FEATURES);
            Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)BiomeMakeover.ID("sunken_ruin"), (Object)SUNKEN_RUIN_PIECE);
            Swamp.setFeatures();
        }

        public static void setFeatures() {
            SWAMP_GEN.put(GenerationStep.Decoration.VEGETAL_DECORATION, Lists.newArrayList((Object[])new Holder[]{SWAMP_CYPRESS_TREES_PLACED, WILLOW_TREES_PLACED, SWAMP_HUGE_SHROOMS, SWAMP_FLOWERS_PLACED, LILY_PAD_PATCH_PLACED}));
            SWAMP_GEN.put(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, Lists.newArrayList((Object[])new Holder[]{PEAT_PLACED, REEDS_PLACED}));
            SWAMP_STRUCTURES.add(SUNKEN_RUIN_CONFIGURED);
        }
    }

    public static class DarkForest {
        public static final Holder<ConfiguredFeature<BlockStateConfiguration, ?>> MESMERITE_BOULDER = BMWorldGen.configure("mesmerite_boulder", BMFeatures.MESMERMITE_BOULDER_FEATURE.get(), new BlockStateConfiguration(BMBlocks.MESMERITE.get().m_49966_()));
        public static final Holder<PlacedFeature> MESMERITE_BOULDER_PLACED = BMWorldGen.place("mesmerite_boulder", MESMERITE_BOULDER, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, RarityFilter.m_191900_((int)10), BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<OreConfiguration, ?>> MESMERITE_UNDERGROUND = BMWorldGen.configure("mesmerite_underground", BMFeatures.MESMERITE_UNDERGROUND_FEATURE.get(), new OreConfiguration(OreFeatures.f_195071_, BMBlocks.MESMERITE.get().m_49966_(), 64));
        public static final Holder<PlacedFeature> MESMERITE_UNDERGROUND_PLACED = BMWorldGen.place("mesmerite_underground", MESMERITE_UNDERGROUND, new PlacementModifier[]{RarityFilter.m_191900_((int)4), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> ITCHING_IVY = BMWorldGen.configure("itching_ivy", BMFeatures.ITCHING_IVY_FEATURE.get());
        public static final Holder<PlacedFeature> ITCHING_IVY_PLACED = BMWorldGen.place("itching_ivy", ITCHING_IVY, new PlacementModifier[]{InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)4), BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> WILD_MUSHROOMS = BMWorldGen.configure("wild_mushrooms", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.WILD_MUSHROOMS.get())), List.of(), (int)12));
        public static final Holder<PlacedFeature> WILD_MUSHROOMS_PLACED = BMWorldGen.place("wild_mushrooms", WILD_MUSHROOMS, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final Holder<PlacedFeature> DF_GRASS_PLACED = BMWorldGen.place("df_grass", VegetationFeatures.f_195182_, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> DF_TALL_GRASS = BMWorldGen.configure("df_tall_grass", Feature.f_65763_, FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50359_))));
        public static final Holder<PlacedFeature> DF_TALL_GRASS_PLACED = BMWorldGen.place("df_tall_grass", DF_TALL_GRASS, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_(), RarityFilter.m_191900_((int)3)});
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PEONY = BMWorldGen.configure("peony", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50358_)), List.of(), (int)7));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> LILAC = BMWorldGen.configure("lilac", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50356_)), List.of(), (int)7));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ROSE = BMWorldGen.configure("rose", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50357_)), List.of(), (int)7));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FOXGLOVE = BMWorldGen.configure("foxglove", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.FOXGLOVE.get())), List.of(), (int)7));
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BLACK_THISTLE = BMWorldGen.configure("black_thistle", Feature.f_65763_, FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)BMBlocks.BLACK_THISTLE.get())), List.of(), (int)7));
        public static final Holder<PlacedFeature> PEONY_PLACED = BMWorldGen.place("peony", PEONY, new PlacementModifier[0]);
        public static final Holder<PlacedFeature> LILAC_PLACED = BMWorldGen.place("lilac", LILAC, new PlacementModifier[0]);
        public static final Holder<PlacedFeature> ROSE_PLACED = BMWorldGen.place("rose", ROSE, new PlacementModifier[0]);
        public static final Holder<PlacedFeature> FOXGLOVE_PLACED = BMWorldGen.place("foxglove", FOXGLOVE, new PlacementModifier[0]);
        public static final Holder<PlacedFeature> BLACK_THISTLE_PLACED = BMWorldGen.place("black_thistle", BLACK_THISTLE, new PlacementModifier[0]);
        public static final Holder<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> FLOWERS = BMWorldGen.configure("df_flowers", Feature.f_65755_, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205800_(List.of(PEONY_PLACED, LILAC_PLACED, ROSE_PLACED, FOXGLOVE_PLACED, BLACK_THISTLE_PLACED))));
        public static final Holder<PlacedFeature> FLOWERS_PLACED = BMWorldGen.place("df_flowers", FLOWERS, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, CountPlacement.m_191630_((IntProvider)ClampedInt.m_146395_((IntProvider)UniformInt.m_146622_((int)-1, (int)8), (int)0, (int)8)), BiomeFilter.m_191561_()});
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> DARK_OAK_SMALL = BMWorldGen.configure("dark_oak_small", Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50004_.m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(7, 8, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50055_.m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)2), 2), (FeatureSize)new TwoLayersFeatureSize(2, 0, 0, OptionalInt.of(3))).m_68244_().m_68249_(List.of(new BeehiveDecorator(0.002f))).m_68251_());
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> ANCIENT_OAK_SMALL = BMWorldGen.configure("ancient_oak_small", Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodTypeInfo.Type.LOG).get().m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(8, 11, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)BMBlocks.ANCIENT_OAK_LEAVES.get().m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)2), 2), (FeatureSize)new TwoLayersFeatureSize(2, 0, 0, OptionalInt.of(3))).m_68249_((List)ImmutableList.of((Object)((Object)IvyDecorator.INSTANCE), (Object)new BeehiveDecorator(0.002f))).m_68244_().m_68251_());
        public static final TrunkPlacerType<AncientOakTrunkPlacer> ANCIENT_OAK_TRUNK = TrunkPlacerTypeInvoker.callRegister(BiomeMakeover.ID("ancient_oak").toString(), AncientOakTrunkPlacer.CODEC);
        public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> ANCIENT_OAK = BMWorldGen.configure("ancient_oak", Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodTypeInfo.Type.LOG).get().m_49966_()), (TrunkPlacer)new AncientOakTrunkPlacer(10, 2, 14), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)BMBlocks.ANCIENT_OAK_LEAVES.get().m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new ThreeLayersFeatureSize(2, 3, 0, 1, 2, OptionalInt.empty())).m_68249_((List)ImmutableList.of((Object)((Object)IvyDecorator.INSTANCE), (Object)new BeehiveDecorator(0.002f))).m_68244_().m_68251_());
        public static final Holder<PlacedFeature> ANCIENT_OAK_SMALL_CHECKED = BMWorldGen.place("ancient_oak_small_checked", ANCIENT_OAK_SMALL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)BMBlocks.ANCIENT_OAK_SAPLING.get())});
        public static final Holder<PlacedFeature> DARK_OAK_SMALL_CHECKED = BMWorldGen.place("dark_oak_small", DARK_OAK_SMALL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)BMBlocks.ANCIENT_OAK_SAPLING.get())});
        public static final Holder<PlacedFeature> ANCIENT_OAK_CHECKED = BMWorldGen.place("ancient_oak", ANCIENT_OAK, new PlacementModifier[]{PlacementUtils.m_206493_((Block)BMBlocks.ANCIENT_OAK_SAPLING.get())});
        public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> DF_TREES = BMWorldGen.configure("df_trees", Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(ANCIENT_OAK_SMALL_CHECKED, 0.1f), new WeightedPlacedFeature(DARK_OAK_SMALL_CHECKED, 0.2f), new WeightedPlacedFeature(ANCIENT_OAK_CHECKED, 0.05f)), TreePlacements.f_195375_));
        public static final Holder<PlacedFeature> DF_TREES_PLACED = BMWorldGen.place("df_trees", DF_TREES, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        public static final ConfiguredStructureFeature<?, ?> MANSION_CONFIGURED = BMFeatures.MANSION.get().m_209769_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, BMFeatures.HAS_REWORKED_MANSION, true);
        public static final StructurePieceType MANSION_PIECE = MansionFeature.Piece::new;

        public static void setFeatures() {
            DF_GEN.put(GenerationStep.Decoration.VEGETAL_DECORATION, Lists.newArrayList((Object[])new Holder[]{WILD_MUSHROOMS_PLACED, DF_GRASS_PLACED, DF_TALL_GRASS_PLACED, FLOWERS_PLACED}));
            DF_GEN.put(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, Lists.newArrayList((Object[])new Holder[]{ITCHING_IVY_PLACED}));
            DF_GEN.put(GenerationStep.Decoration.UNDERGROUND_DECORATION, Lists.newArrayList());
            DF_GEN.put(GenerationStep.Decoration.UNDERGROUND_ORES, Lists.newArrayList((Object[])new Holder[]{MESMERITE_UNDERGROUND_PLACED, DF_TREES_PLACED}));
            DF_GEN.put(GenerationStep.Decoration.LOCAL_MODIFICATIONS, Lists.newArrayList((Object[])new Holder[]{MESMERITE_BOULDER_PLACED}));
            DF_GEN.put(GenerationStep.Decoration.SURFACE_STRUCTURES, Lists.newArrayList());
            DF_STRUCTURES.add(MANSION_CONFIGURED);
        }

        public static void init() {
            Holder mansionHolder = BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_123862_, (ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)BiomeMakeover.ID("mansion")), MANSION_CONFIGURED);
            StructureSets.m_211131_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)BiomeMakeover.ID("mansion")), (Holder)mansionHolder, (StructurePlacement)new RandomSpreadStructurePlacement(32, 9, RandomSpreadType.LINEAR, 420));
            RegistryHelper.register("biomemakeover", Registry.f_122841_, StructureFeature.class, DarkForest.class, new RegistryHelper.RegistryCallback[0]);
            RegistryHelper.register("biomemakeover", Registry.f_122839_, Feature.class, DarkForest.class, new RegistryHelper.RegistryCallback[0]);
            RegistryHelper.gatherFields("biomemakeover", ConfiguredFeature.class, DarkForest.class, CFG_FEATURES);
            RegistryHelper.gatherFields("biomemakeover", PlacedFeature.class, DarkForest.class, PL_FEATURES);
            DarkForest.setFeatures();
            Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)BiomeMakeover.ID("mansion"), (Object)MANSION_PIECE);
        }
    }
}

