/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.ToadEntity;
import party.lemons.biomemakeover.util.MathUtils;

public class ToadModel
extends EntityModel<ToadEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("toad"), "main");
    private final ModelPart bone;
    private final ModelPart frontlege;
    private final ModelPart backlege;
    private final ModelPart frontlegw;
    private final ModelPart backlegw;
    private final ModelPart lipTop;
    private final ModelPart lipBottom;
    private final ModelPart tounge;
    static float tongueDistance;

    public ToadModel(ModelPart root) {
        this.bone = root.m_171324_("bone");
        this.frontlege = this.bone.m_171324_("frontlege");
        this.backlege = this.bone.m_171324_("backlege");
        this.frontlegw = this.bone.m_171324_("frontlegw");
        this.backlegw = this.bone.m_171324_("backlegw");
        this.lipTop = this.bone.m_171324_("lips").m_171324_("bone3");
        this.lipBottom = this.bone.m_171324_("lips").m_171324_("bone4");
        this.tounge = this.bone.m_171324_("tounge");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -3.7273f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(10, 24).m_171488_(1.0f, -7.0f, -2.7273f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-3.0f, -7.0f, -2.7273f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-0.2727f));
        PartDefinition backlege = bone.m_171599_("backlege", CubeListBuilder.m_171558_().m_171514_(8, 16).m_171488_(-2.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 16).m_171488_(-2.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)3.2727f));
        PartDefinition backlegw = bone.m_171599_("backlegw", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(0.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(0.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)3.2727f));
        PartDefinition eyeballw = bone.m_171599_("eyeballw", CubeListBuilder.m_171558_().m_171514_(18, 28).m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-6.5f, (float)-1.2273f));
        PartDefinition eyeballe = bone.m_171599_("eyeballe", CubeListBuilder.m_171558_().m_171514_(24, 3).m_171488_(-1.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-6.5f, (float)-1.2273f));
        PartDefinition lips = bone.m_171599_("lips", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-3.7273f));
        PartDefinition bone3 = lips.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(20, 18).m_171488_(-3.0f, 1.0f, -1.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone4 = lips.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(20, 16).m_171488_(-3.0f, 0.0f, -1.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontlegw = bone.m_171599_("frontlegw", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-2.0f, (float)-2.7273f));
        PartDefinition cube_r1 = frontlegw.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(22, 22).m_171488_(0.0f, 0.684f, -1.3794f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition frontlege = bone.m_171599_("frontlege", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-2.0f, (float)-2.7273f));
        PartDefinition cube_r2 = frontlege.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -6.0f, 0.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tounge = bone.m_171599_("tounge", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-0.9f, -3.0f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.7273f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ToadEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        float legAmount = 1.4f;
        this.frontlege.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f + pi)) * 1.4f * limbDistance;
        this.backlege.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f)) * legAmount * limbDistance;
        this.frontlegw.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f)) * 1.4f * limbDistance;
        this.backlegw.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f + pi)) * legAmount * limbDistance;
        if (!entity.m_20096_()) {
            this.backlegw.f_104203_ = 2.0f;
            this.backlege.f_104203_ = 2.0f;
        }
        if (entity.hasTongueEntity()) {
            entity.mouthDistance = MathUtils.approachValue(entity.mouthDistance, 1.0f, 0.5f);
            Entity e = entity.f_19853_.m_6815_(entity.getTongueEntityID());
            tongueDistance = e != null && entity.isTongueReady() ? entity.m_20270_(e) * 16.0f - (float)(e.m_142469_().f_82291_ - e.m_142469_().f_82288_) * 16.0f : 0.0f;
        } else {
            entity.mouthDistance = MathUtils.approachValue(entity.mouthDistance, 0.0f, 0.1f);
        }
        this.lipTop.f_104201_ = -entity.mouthDistance;
        this.lipBottom.f_104201_ = entity.mouthDistance;
        this.tounge.f_104203_ = -0.2618f + headPitch * 0.0175f;
        this.tounge.f_104204_ = headYaw * 0.0175f;
    }

    public ModelPart getTounge() {
        return this.tounge;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bone.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

