/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.entity.render.StoneGolemModel;

public class StoneGolemRender
extends MobRenderer<StoneGolemEntity, StoneGolemModel> {
    public static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/stone_golem/stone_golem.png");

    public StoneGolemRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new StoneGolemModel(context.m_174023_(StoneGolemModel.LAYER_LOCATION)), 1.0f);
        this.m_115326_(new StoneGolemItemLayer(this));
        this.m_115326_(new StoneGolemCrackLayer(this));
    }

    public void render(StoneGolemEntity entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.m_85836_();
        boolean visible = this.m_5933_((LivingEntity)entity);
        boolean isInvis = !visible && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        boolean outline = Minecraft.m_91087_().m_91314_((Entity)entity);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, (double)-1.501f, 0.0);
        RenderType renderLayer = this.m_7225_((LivingEntity)entity, visible, isInvis, outline);
        if (renderLayer != null) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderLayer);
            int overlay = StoneGolemRender.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, g));
            ((StoneGolemModel)this.m_7200_()).renderBaseToBuffer(poseStack, vertexConsumer, i, overlay, 1.0f, 1.0f, 1.0f, isInvis ? 0.15f : 1.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Mob)entity, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(StoneGolemEntity entity) {
        return TEXTURE;
    }

    private class StoneGolemItemLayer
    extends RenderLayer<StoneGolemEntity, StoneGolemModel> {
        public StoneGolemItemLayer(StoneGolemRender stoneGolemRender2) {
            super((RenderLayerParent)stoneGolemRender2);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, StoneGolemEntity entity, float f, float g, float h, float j, float k, float l) {
            ItemStack rightHand;
            boolean rightHanded = entity.m_5737_() == HumanoidArm.RIGHT;
            ItemStack leftHand = rightHanded ? entity.m_21206_() : entity.m_21205_();
            ItemStack itemStack = rightHand = rightHanded ? entity.m_21205_() : entity.m_21206_();
            if (!leftHand.m_41619_() || !rightHand.m_41619_()) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.5, 0.0);
                this.renderItem(entity, rightHand, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, multiBufferSource, i);
                this.renderItem(entity, leftHand, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }

        private void renderItem(StoneGolemEntity entity, ItemStack stack, ItemTransforms.TransformType transformationMode, HumanoidArm arm, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
            if (!stack.m_41619_()) {
                poseStack.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(arm, poseStack);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                boolean isLeft = arm == HumanoidArm.LEFT;
                poseStack.m_85837_((double)((isLeft ? -0.7f : 0.7f) / 16.0f), 0.125, -1.75);
                Minecraft.m_91087_().m_91292_().m_109322_((LivingEntity)entity, stack, transformationMode, isLeft, poseStack, multiBufferSource, light);
                poseStack.m_85849_();
            }
        }
    }

    private static class StoneGolemCrackLayer
    extends RenderLayer<StoneGolemEntity, StoneGolemModel> {
        private static final Map<IronGolem.Crackiness, ResourceLocation> DAMAGE_TO_TEXTURE = ImmutableMap.of((Object)IronGolem.Crackiness.LOW, (Object)BiomeMakeover.ID("textures/entity/stone_golem/stone_golem_damaged_light.png"), (Object)IronGolem.Crackiness.MEDIUM, (Object)BiomeMakeover.ID("textures/entity/stone_golem/stone_golem_damaged_medium.png"), (Object)IronGolem.Crackiness.HIGH, (Object)BiomeMakeover.ID("textures/entity/stone_golem/stone_golem_damaged_high.png"));

        public StoneGolemCrackLayer(StoneGolemRender stoneGolemRender) {
            super((RenderLayerParent)stoneGolemRender);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, StoneGolemEntity entity, float f, float g, float h, float j, float k, float l) {
            IronGolem.Crackiness crack;
            if (!entity.m_20145_() && (crack = entity.getCrack()) != IronGolem.Crackiness.NONE) {
                ResourceLocation identifier = DAMAGE_TO_TEXTURE.get(crack);
                StoneGolemCrackLayer.m_117376_((EntityModel)this.m_117386_(), (ResourceLocation)identifier, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

