/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.MushroomVillagerEntity;
import party.lemons.biomemakeover.init.BMBlocks;

public class MushroomTraderRender
extends MobRenderer<MushroomVillagerEntity, VillagerModel<MushroomVillagerEntity>> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/mushrooming_trader_inner.png");

    public MushroomTraderRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VillagerModel(context.m_174023_(ModelLayers.f_171210_)), 0.5f);
        this.m_115326_(new MushroomTraderOverlay(this, (VillagerModel<MushroomVillagerEntity>)new VillagerModel(context.m_174023_(ModelLayers.f_171210_))));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new CrossedArmsItemLayer((RenderLayerParent)this));
        this.m_115326_(new MushroomTraderFeatures(this));
    }

    public ResourceLocation getTextureLocation(MushroomVillagerEntity entity) {
        return TEXTURE;
    }

    protected int getBlockLightLevel(MushroomVillagerEntity entity, BlockPos blockPos) {
        return 15;
    }

    protected void scale(MushroomVillagerEntity wanderingTraderEntity, PoseStack matrixStack, float f) {
        float g = 0.9375f;
        matrixStack.m_85841_(g, g, g);
    }

    private static class MushroomTraderOverlay
    extends RenderLayer<MushroomVillagerEntity, VillagerModel<MushroomVillagerEntity>> {
        private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/mushrooming_trader_outer.png");
        private final VillagerModel<MushroomVillagerEntity> model;

        public MushroomTraderOverlay(MushroomTraderRender mushroomTraderRender, VillagerModel<MushroomVillagerEntity> model) {
            super((RenderLayerParent)mushroomTraderRender);
            this.model = model;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, MushroomVillagerEntity entity, float f, float g, float h, float j, float k, float l) {
            int light = this.getPackedLightCoords(entity, l);
            ((VillagerModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6973_((Entity)entity, f, g, j, k, l);
            MushroomTraderOverlay.m_117376_(this.model, (ResourceLocation)TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)light, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public final int getPackedLightCoords(MushroomVillagerEntity entity, float f) {
            BlockPos blockPos = new BlockPos(entity.m_7371_(f));
            return LightTexture.m_109885_((int)this.getBlockLightLevel(entity, blockPos), (int)this.getSkyLightLevel(entity, blockPos));
        }

        protected int getSkyLightLevel(MushroomVillagerEntity entity, BlockPos blockPos) {
            return entity.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        }

        protected int getBlockLightLevel(MushroomVillagerEntity entity, BlockPos blockPos) {
            if (entity.m_6060_()) {
                return 15;
            }
            return entity.f_19853_.m_45517_(LightLayer.BLOCK, blockPos);
        }

        protected int getOverlayLight(MushroomVillagerEntity entity, BlockPos blockPos) {
            if (entity.m_6060_()) {
                return 15;
            }
            return entity.f_19853_.m_45517_(LightLayer.BLOCK, blockPos);
        }
    }

    private static class MushroomTraderFeatures
    extends RenderLayer<MushroomVillagerEntity, VillagerModel<MushroomVillagerEntity>> {
        public MushroomTraderFeatures(MushroomTraderRender mushroomTraderRender) {
            super((RenderLayerParent)mushroomTraderRender);
        }

        public void render(PoseStack pose, MultiBufferSource mbs, int i, MushroomVillagerEntity e, float f, float g, float h, float j, float k, float l) {
            if (!e.m_6162_() && !e.m_20145_()) {
                BlockRenderDispatcher blockRenderManager = Minecraft.m_91087_().m_91289_();
                BlockState shroom = BMBlocks.GREEN_GLOWSHROOM.get().m_49966_();
                int m = LivingEntityRenderer.m_115338_((LivingEntity)e, (float)0.0f);
                pose.m_85836_();
                ((VillagerModel)this.m_117386_()).m_5585_().m_104299_(pose);
                pose.m_85837_(0.0, -1.0, 0.0);
                pose.m_85845_(Vector3f.f_122225_.m_122240_(-78.0f));
                pose.m_85841_(-1.0f, -1.0f, 1.0f);
                pose.m_85837_(-0.5, -0.5, -0.5);
                blockRenderManager.m_110912_(shroom, pose, mbs, i, m);
                pose.m_85849_();
                pose.m_85836_();
                ((VillagerModel)this.m_117386_()).m_5585_().m_104299_(pose);
                pose.m_85837_(-0.4, -0.5, -0.5);
                pose.m_85845_(Vector3f.f_122223_.m_122240_(75.0f));
                pose.m_85845_(Vector3f.f_122226_.m_122240_(30.0f));
                pose.m_85841_(-1.0f, -1.0f, 1.0f);
                pose.m_85837_(-0.5, -0.5, -0.5);
                blockRenderManager.m_110912_(shroom, pose, mbs, i, m);
                pose.m_85849_();
            }
        }
    }
}

