/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorStateProvider;
import party.lemons.biomemakeover.util.AnimationHelper;

public class AdjudicatorModel<T extends Monster>
extends EntityModel<T>
implements HeadedModel,
ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("adjudicator"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arm_left;
    private final ModelPart arm_right;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public AdjudicatorModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.arm_left = this.body.m_171324_("arm_left");
        this.arm_right = this.body.m_171324_("arm_right");
        this.leg_left = this.body.m_171324_("leg_left");
        this.leg_right = this.body.m_171324_("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -11.25f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.25f, (float)0.0f));
        PartDefinition robe = body.m_171599_("robe", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-4.0f, -0.5f, -3.0f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.25f, (float)0.0f));
        PartDefinition arm_left = body.m_171599_("arm_left", CubeListBuilder.m_171558_().m_171514_(14, 38).m_171488_(-1.2f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(32, 16).m_171488_(-1.5f, -3.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)-9.25f, (float)0.5f));
        PartDefinition arm_right = body.m_171599_("arm_right", CubeListBuilder.m_171558_().m_171514_(26, 43).m_171488_(-1.8f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(32, 16).m_171488_(-2.5f, -3.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)-9.25f, (float)0.5f));
        PartDefinition leg_left = body.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-1.5f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)1.75f, (float)0.0f));
        PartDefinition leg_right = body.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.5f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)1.75f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(38, 44).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -2.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadyRot, float headxRot) {
        AnimationHelper.setRotation(this.leg_left, 0.0f, 0.0f, 0.0f);
        AnimationHelper.setRotation(this.leg_right, 0.0f, 0.0f, 0.0f);
        AnimationHelper.rotateHead(this.head, headxRot, netHeadyRot);
        this.body.f_104204_ = 0.0f;
        AnimationHelper.swingLimb(this.leg_left, this.leg_right, limbSwing, limbSwingAmount, 1.25f);
        this.arm_right.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.arm_right.f_104204_ = 0.0f;
        this.arm_right.f_104205_ = 0.0f;
        this.arm_left.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.arm_left.f_104204_ = 0.0f;
        this.arm_left.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.arm_right.f_104203_ += -0.63f;
            this.arm_left.f_104203_ += -0.63f;
            this.leg_right.f_104203_ = -1.4f;
            this.leg_right.f_104204_ = 0.31f;
            this.leg_right.f_104205_ = 0.078f;
            this.leg_left.f_104203_ = -1.41f;
            this.leg_left.f_104204_ = -0.31f;
            this.leg_left.f_104205_ = -0.078f;
        }
        switch (((AdjudicatorStateProvider)entity).getState()) {
            case WAITING: {
                AnimationHelper.setRotation(this.head, -0.567232f, 0.0f, 0.0f);
                AnimationHelper.setRotation(this.arm_left, -0.349066f, 0.0f, -2.53073f);
                AnimationHelper.setRotation(this.arm_right, -0.349066f, 0.0f, 2.53073f);
                AnimationHelper.setRotation(this.leg_left, -1.701696f, 0.4799655f, 0.0f);
                AnimationHelper.setRotation(this.leg_right, -1.309f, -0.0872665f, 0.0f);
                break;
            }
            case SUMMONING: 
            case TELEPORT: {
                this.arm_right.f_104203_ = Mth.m_14089_((float)(limbSwingAmount * 0.6662f)) * 0.25f;
                this.arm_left.f_104203_ = Mth.m_14089_((float)(limbSwingAmount * 0.6662f)) * 0.25f;
                this.arm_right.f_104205_ = 2.3561945f;
                this.arm_left.f_104205_ = -2.3561945f;
                this.arm_right.f_104204_ = 0.0f;
                this.arm_left.f_104204_ = 0.0f;
                break;
            }
            case FIGHTING: {
                if (!entity.m_21205_().m_41619_()) {
                    Item item = entity.m_21205_().m_41720_();
                    if (item instanceof BowItem) {
                        this.arm_right.f_104204_ = -0.1f + this.head.f_104204_;
                        this.arm_right.f_104203_ = -1.5707964f + this.head.f_104203_;
                        this.arm_left.f_104203_ = -0.9424779f + this.head.f_104203_;
                        this.arm_left.f_104204_ = this.head.f_104204_ - 0.4f;
                        this.arm_left.f_104205_ = 1.5707964f;
                        break;
                    }
                    if (!(item instanceof AxeItem) && !(item instanceof SwordItem)) break;
                    AnimationUtils.m_102091_((ModelPart)this.arm_right, (ModelPart)this.arm_left, entity, (float)this.f_102608_, (float)limbSwingAmount);
                    break;
                }
                AnimationUtils.m_102102_((ModelPart)this.arm_left, (ModelPart)this.arm_right, (boolean)true, (float)this.f_102608_, (float)limbSwingAmount);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.getAttackingArm(humanoidArm).m_104299_(poseStack);
    }

    private ModelPart getAttackingArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.arm_left : this.arm_right;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

