/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.phase.AdjudicatorPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.TimedPhase;
import party.lemons.biomemakeover.entity.event.EntityEvent;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.NBTUtil;
import party.lemons.biomemakeover.util.effect.BiomeMakeoverEffect;
import party.lemons.biomemakeover.util.effect.EffectHelper;

public class TeleportingPhase
extends TimedPhase {
    private BlockPos teleportPos;
    private AdjudicatorPhase nextPhase;

    public TeleportingPhase(ResourceLocation phaseID, AdjudicatorEntity adjudicator) {
        super(phaseID, 30, adjudicator);
        this.teleportPos = new BlockPos(adjudicator.m_20182_());
    }

    @Override
    protected void initAI() {
    }

    @Override
    public void tick() {
        super.tick();
        this.adjudicator.broadcastEvent((Entity)this.adjudicator, EntityEvent.ENDER_PARTICLES);
        this.adjudicator.broadcastEvent((Entity)this.adjudicator, EntityEvent.TELEPORT_PARTICLES);
        EffectHelper.doEffect(this.level, BiomeMakeoverEffect.BLOCK_ENDER_PARTICLES, this.teleportPos);
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        this.nextPhase = this.selectNextPhase();
        this.teleportPos = this.nextPhase.getStartPosition();
        this.adjudicator.setState(AdjudicatorState.TELEPORT);
        this.adjudicator.m_5496_(BMEffects.ADJUDICATOR_SPELL_3.get(), 1.0f, 1.0f);
    }

    @Override
    public void onExitPhase() {
        super.onExitPhase();
        this.adjudicator.teleportTo(this.teleportPos);
        this.adjudicator.setState(AdjudicatorState.FIGHTING);
    }

    @Override
    public AdjudicatorPhase getNextPhase() {
        return this.nextPhase;
    }

    public AdjudicatorPhase selectNextPhase() {
        AdjudicatorPhase nextPhase;
        List<AdjudicatorPhase> phases = this.adjudicator.PHASES.values().stream().filter(AdjudicatorPhase::isSelectable).toList();
        while ((nextPhase = phases.get(this.level.f_46441_.nextInt(phases.size()))) == this) {
        }
        return nextPhase;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = super.toTag();
        NBTUtil.writeBlockPos(this.teleportPos, tag);
        return tag;
    }

    @Override
    public void fromTag(CompoundTag tag) {
        super.fromTag(tag);
        this.teleportPos = NBTUtil.readBlockPos(tag);
    }
}

