/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.ai.FlyWanderGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;

public class MothEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> TARGETING = SynchedEntityData.m_135353_(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean hasPlayedLoop = false;
    private float currentPitch;
    private float lastPitch;
    private AttractLightGoal attractLightGoal;
    private MoveToLightGoal moveToLightGoal;
    private BlockPos attactPos;

    public MothEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected void m_8099_() {
        this.attractLightGoal = new AttractLightGoal();
        this.moveToLightGoal = new MoveToLightGoal();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, OwlEntity.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)this.attractLightGoal);
        this.f_21345_.m_25352_(4, (Goal)this.moveToLightGoal);
        this.f_21345_.m_25352_(5, (Goal)new FlyWanderGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TARGETING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MothEntity.m_33035_().m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        if (levelReader.m_8055_(blockPos).m_60795_()) {
            return 10.0f + (float)levelReader.m_7146_(blockPos);
        }
        return super.m_5610_(blockPos, levelReader);
    }

    public float m_20998_(float delta) {
        return Mth.m_14179_((float)delta, (float)this.lastPitch, (float)this.currentPitch);
    }

    private void updateBodyPitch() {
        this.lastPitch = this.currentPitch;
        this.currentPitch = this.isNearTarget() ? Math.min(1.0f, this.currentPitch + 0.2f) : Math.max((float)Math.sin((float)this.f_19797_ / 10.0f) / 10.0f, this.currentPitch - 0.24f);
    }

    public static boolean checkSpawnRules(EntityType<? extends MothEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, Random random) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (Random)random) && (mobSpawnType == MobSpawnType.SPAWNER || levelAccessor.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13035_));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                if (!MothEntity.this.attractLightGoal.isRunning()) {
                    super.m_7638_();
                }
            }
        };
        birdNavigation.m_26443_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26440_(false);
        return birdNavigation;
    }

    private boolean isAttractive(BlockPos pos) {
        return this.f_19853_.m_46749_(pos) && this.f_19853_.m_8055_(pos).m_60791_() > 10 || this.f_19853_.m_8055_(pos).m_204336_(BMBlocks.MOTH_ATTRACTIVE);
    }

    protected float m_6041_() {
        BlockState state = this.m_20075_();
        Block block = state.m_60734_();
        float mult = state.m_204336_(BMBlocks.ITCHING_IVY_TAG) ? 1.0f : block.m_49961_();
        if (block != Blocks.f_49990_ && block != Blocks.f_50628_) {
            if (mult == 1.0f) {
                BlockState velBlock = this.f_19853_.m_8055_(this.m_20099_());
                if (!velBlock.m_204336_(BMBlocks.ITCHING_IVY_TAG)) {
                    return velBlock.m_60734_().m_49961_();
                }
                return mult;
            }
            return mult;
        }
        return mult;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected SoundEvent m_7515_() {
        return BMEffects.MOTH_IDLE.get();
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected boolean m_142039_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateBodyPitch();
    }

    private boolean isNearTarget() {
        return false;
    }

    public boolean isTargeting() {
        return (Boolean)this.m_20088_().m_135370_(TARGETING);
    }

    private boolean closerThan(BlockPos pos, int distance) {
        return pos.m_123314_((Vec3i)this.m_20097_(), (double)distance);
    }

    private boolean isTooFar(BlockPos pos) {
        return !this.closerThan(pos, 32);
    }

    private void startMovingTo(BlockPos pos) {
        Vec3 vec32;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)this.m_20097_());
        int i = 0;
        BlockPos blockPos2 = this.m_142538_();
        int j = (int)vec3.f_82480_ - blockPos2.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos2.m_123333_((Vec3i)this.m_20097_());
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec32 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) == null) {
            return;
        }
        this.f_21344_.m_26529_(0.5f);
        this.f_21344_.m_26519_(vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, 1.0);
    }

    protected SoundEvent m_5592_() {
        return BMEffects.MOTH_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return BMEffects.MOTH_HURT.get();
    }

    public boolean m_7327_(Entity entity) {
        boolean attacked = super.m_7327_((Entity)this.m_5448_());
        if (attacked) {
            this.m_5496_(BMEffects.MOTH_BITE.get(), 1.0f, 1.0f);
        }
        return attacked;
    }

    private class AttractLightGoal
    extends NotAttackingGoal {
        private int attractTicks;
        private int lastAttractTick;
        private boolean running;
        private Vec3 nextTarget;
        private int ticks;

        AttractLightGoal() {
            this.attractTicks = 0;
            this.lastAttractTick = 0;
            this.ticks = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canMothStart() {
            if (MothEntity.this.f_19853_.m_46471_()) {
                return false;
            }
            if (MothEntity.this.f_19796_.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.findLight();
            if (optional.isPresent()) {
                MothEntity.this.attactPos = optional.get();
                MothEntity.this.f_21344_.m_26519_((double)MothEntity.this.attactPos.m_123341_() + 0.5, (double)MothEntity.this.attactPos.m_123342_() + 1.25, (double)MothEntity.this.attactPos.m_123343_() + 0.5, (double)1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean canMothContinue() {
            if (!this.running) {
                return false;
            }
            if (MothEntity.this.attactPos == null) {
                return false;
            }
            if (MothEntity.this.f_19853_.m_46471_()) {
                return false;
            }
            if (this.completedAttract()) {
                return MothEntity.this.f_19796_.nextFloat() < 0.2f;
            }
            if (MothEntity.this.f_19797_ % 20 == 0 && !MothEntity.this.isAttractive(MothEntity.this.attactPos)) {
                MothEntity.this.attactPos = null;
                return false;
            }
            if (MothEntity.this.attactPos != null && (double)MothEntity.this.attactPos.m_123342_() < MothEntity.this.m_20186_() && !MothEntity.this.closerThan(MothEntity.this.attactPos, 1) && MothEntity.this.f_19853_.m_8055_(MothEntity.this.m_20097_().m_7495_()).m_60815_()) {
                MothEntity.this.attactPos = null;
                return false;
            }
            return true;
        }

        private boolean completedAttract() {
            return this.attractTicks > 400;
        }

        private boolean isRunning() {
            return this.running;
        }

        private void cancel() {
            this.running = false;
        }

        public void m_8056_() {
            this.attractTicks = 0;
            this.ticks = 0;
            this.lastAttractTick = 0;
            this.running = true;
        }

        public void m_8041_() {
            this.running = false;
            MothEntity.this.f_21344_.m_26573_();
        }

        public void m_8037_() {
            ++this.ticks;
            if (this.ticks > 600) {
                MothEntity.this.attactPos = null;
            } else {
                BlockPos pos;
                Vec3 onVec;
                Vec3 centerTarget = Vec3.m_82539_((Vec3i)MothEntity.this.attactPos);
                centerTarget = MothEntity.this.m_20186_() < centerTarget.f_82480_ ? centerTarget.m_82520_(0.0, -1.25, 0.0) : centerTarget.m_82520_(0.0, 1.25, 0.0);
                if (centerTarget.m_82554_(onVec = new Vec3((double)(pos = MothEntity.this.m_20097_()).m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) > 1.0) {
                    this.nextTarget = centerTarget;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = centerTarget;
                    }
                    boolean isClose = onVec.m_82554_(this.nextTarget) <= 0.1;
                    boolean hasFinished = true;
                    if (!isClose && this.ticks > 600) {
                        MothEntity.this.attactPos = null;
                    } else {
                        if (isClose) {
                            boolean getNewTarget;
                            boolean bl = getNewTarget = MothEntity.this.f_19796_.nextInt(25) == 0;
                            if (getNewTarget) {
                                this.nextTarget = new Vec3(centerTarget.m_7096_() + (double)this.getRandomOffset(), centerTarget.m_7098_(), centerTarget.m_7094_() + (double)this.getRandomOffset());
                                MothEntity.this.f_21344_.m_26573_();
                            } else {
                                hasFinished = false;
                            }
                            MothEntity.this.m_21563_().m_24946_(centerTarget.m_7096_(), centerTarget.m_7098_(), centerTarget.m_7094_());
                        }
                        if (hasFinished) {
                            this.moveToNextTarget();
                        }
                        ++this.attractTicks;
                        if (MothEntity.this.f_19796_.nextFloat() < 0.05f && this.attractTicks > this.lastAttractTick + 60) {
                            this.lastAttractTick = this.attractTicks;
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            MothEntity.this.m_21566_().m_6849_(this.nextTarget.m_7096_(), this.nextTarget.m_7098_(), this.nextTarget.m_7094_(), (double)0.35f);
        }

        private float getRandomOffset() {
            return (MothEntity.this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> findLight() {
            return this.findLight(5.0);
        }

        private Optional<BlockPos> findLight(double searchDistance) {
            BlockPos blockPos = MothEntity.this.m_20097_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int y = 0;
            while ((double)y <= searchDistance) {
                int j = 0;
                while ((double)j < searchDistance) {
                    int x = 0;
                    while (x <= j) {
                        int z;
                        int n = z = x < j && x > -j ? j : 0;
                        while (z <= j) {
                            mutable.m_122154_((Vec3i)blockPos, x, y - 1, z);
                            if (blockPos.m_123314_((Vec3i)mutable, searchDistance) && MothEntity.this.isAttractive((BlockPos)mutable)) {
                                return Optional.of(mutable);
                            }
                            z = z > 0 ? -z : 1 - z;
                        }
                        x = x > 0 ? -x : 1 - x;
                    }
                    ++j;
                }
                y = y > 0 ? -y : 1 - y;
            }
            return Optional.empty();
        }
    }

    public class MoveToLightGoal
    extends NotAttackingGoal {
        private int ticks;

        MoveToLightGoal() {
            this.ticks = MothEntity.this.f_19853_.f_46441_.nextInt(10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canMothContinue() {
            return MothEntity.this.attactPos != null && !MothEntity.this.m_21536_() && MothEntity.this.isAttractive(MothEntity.this.attactPos) && !MothEntity.this.closerThan(MothEntity.this.attactPos, 2);
        }

        @Override
        public boolean canMothStart() {
            return this.canMothContinue();
        }

        public void m_8056_() {
            this.ticks = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.ticks = 0;
            MothEntity.this.f_21344_.m_26573_();
            MothEntity.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (MothEntity.this.attactPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    MothEntity.this.attactPos = null;
                } else if (!MothEntity.this.f_21344_.m_26572_()) {
                    if (MothEntity.this.isTooFar(MothEntity.this.attactPos)) {
                        MothEntity.this.attactPos = null;
                    } else {
                        MothEntity.this.startMovingTo(MothEntity.this.attactPos);
                    }
                }
            }
        }
    }

    private abstract class NotAttackingGoal
    extends Goal {
        private NotAttackingGoal() {
        }

        public abstract boolean canMothContinue();

        public abstract boolean canMothStart();

        public boolean m_8036_() {
            return this.canMothStart() && !MothEntity.this.isTargeting();
        }

        public boolean m_8045_() {
            return this.canMothContinue() && !MothEntity.this.isTargeting();
        }
    }
}

