/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch.menu;

import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import party.lemons.biomemakeover.crafting.witch.SimpleWitch;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestEntity;
import party.lemons.biomemakeover.crafting.witch.WitchQuestHandler;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.crafting.witch.menu.WitchScreen;
import party.lemons.biomemakeover.init.BMAdvancements;
import party.lemons.biomemakeover.init.BMScreens;

public class WitchMenu
extends AbstractContainerMenu {
    private final WitchQuestEntity witch;
    private final SimpleContainer container;

    public WitchMenu(int containerID, Inventory playerInventory) {
        this(containerID, playerInventory, new SimpleWitch(playerInventory.f_35978_));
    }

    public WitchMenu(int containerID, Inventory playerInventory, WitchQuestEntity witch) {
        super(BMScreens.WITCH.get(), containerID);
        int k;
        this.witch = witch;
        this.container = new SimpleContainer(1);
        this.m_38897_(new Slot((Container)this.container, 0, 131, 36){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }
        });
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + k * 9 + 9, 6 + j * 18, 100 + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 6 + k * 18, 158));
        }
    }

    public boolean m_6875_(Player player) {
        return this.witch.getCurrentCustomer() == player && this.witch.canInteract(player);
    }

    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return false;
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack stack;
        if (i == 0 && !this.m_38903_(stack = this.m_38853_(0).m_7993_(), 1, 37, true)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.witch.setCurrentCustomer(null);
        if (!this.witch.getWitchLevel().m_5776_()) {
            if (!(!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_())) {
                player.m_150109_().m_150079_(this.container.m_8016_(0));
            } else {
                ItemStack itemStack = this.container.m_8016_(0);
                if (!itemStack.m_41619_()) {
                    player.m_36176_(itemStack, false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setQuests(WitchQuestList quests) {
        this.witch.setQuestsFromServer(quests);
        if (Minecraft.m_91087_().f_91080_ instanceof WitchScreen) {
            ((WitchScreen)Minecraft.m_91087_().f_91080_).updateQuests();
        }
    }

    public WitchQuestList getQuests() {
        return this.witch.getQuests();
    }

    private void playYesSound() {
        if (!this.witch.getWitchLevel().m_5776_()) {
            Entity entity = (Entity)this.witch;
            entity.m_5496_(this.witch.getYesSound(), 1.0f, 1.0f);
        }
    }

    public void completeQuest(Player playerEntity, WitchQuest quest) {
        if (quest.hasItems((Container)playerEntity.m_150109_())) {
            if (!this.container.m_8020_(0).m_41619_()) {
                playerEntity.m_36176_(this.container.m_8020_(0), true);
            }
            if (!playerEntity.f_19853_.m_5776_()) {
                BMAdvancements.WITCH_TRADE.trigger((ServerPlayer)playerEntity);
            }
            ItemStack reward = WitchQuestHandler.getRewardFor(quest, playerEntity.m_21187_());
            this.witch.completeQuest(quest);
            this.playYesSound();
            quest.consumeItems(playerEntity.m_150109_());
            this.getQuests().remove(quest);
            this.container.m_6836_(0, reward);
        }
    }
}

