/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.crafting.witch.QuestCategory;
import party.lemons.biomemakeover.crafting.witch.QuestItem;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.crafting.witch.data.QuestCategories;
import party.lemons.biomemakeover.network.S2C_HandleWitchQuests;

public class WitchQuestHandler {
    private static final ShufflingList<Integer> ITEM_COUNT_SELECTOR = new ShufflingList();

    public static ItemStack getRewardFor(WitchQuest quest, Random random) {
        QuestRarity rarity = QuestRarity.getRarityFromQuest(quest);
        return rarity.rewards.sample().pickRandom(random);
    }

    public static WitchQuest createQuest(Random random) {
        List counts = ITEM_COUNT_SELECTOR.m_147922_().m_147932_().toList();
        int count = (Integer)counts.get(random.nextInt(counts.size()));
        ArrayList questItems = Lists.newArrayList();
        for (int safetyCount = count * 2; questItems.size() < count && safetyCount > 0; --safetyCount) {
            QuestCategory category = QuestCategories.choose();
            List<QuestItem> itemPool = category.getRequestedItemPool();
            QuestItem item = itemPool.get(random.nextInt(itemPool.size()));
            if (questItems.contains(item)) continue;
            questItems.add(item);
        }
        WitchQuest quest = new WitchQuest(random, questItems);
        return quest;
    }

    public static void sendQuests(Player player, int index, WitchQuestList quests) {
        if (player.f_19853_.m_5776_()) {
            return;
        }
        new S2C_HandleWitchQuests(index, quests).sendTo((ServerPlayer)player);
    }

    public static void init() {
    }

    static {
        ITEM_COUNT_SELECTOR.m_147929_((Object)1, 5);
        ITEM_COUNT_SELECTOR.m_147929_((Object)2, 8);
        ITEM_COUNT_SELECTOR.m_147929_((Object)3, 4);
        ITEM_COUNT_SELECTOR.m_147929_((Object)4, 3);
        ITEM_COUNT_SELECTOR.m_147929_((Object)5, 1);
    }
}

