/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Rarity;
import party.lemons.biomemakeover.crafting.witch.QuestRewardTable;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.util.WeightedList;

public enum QuestRarity {
    COMMON(Rarity.COMMON, 0, new int[]{110, 150, 10, 1}),
    UNCOMMON(Rarity.UNCOMMON, 8, new int[]{90, 120, 75, 10}),
    RARE(Rarity.RARE, 15, new int[]{0, 0, 100, 50}),
    EPIC(Rarity.EPIC, 30, new int[]{0, 0, 0, 100});

    private final int requiredPoints;
    private final Rarity vanillaRarity;
    public final WeightedList<QuestRewardTable> rewards;

    private QuestRarity(Rarity rarity, int requiredPoints, int[] rewardWeights) {
        this.requiredPoints = requiredPoints;
        this.vanillaRarity = rarity;
        this.rewards = new WeightedList();
        this.rewards.add(QuestRewardTable.ITEMS, rewardWeights[0]);
        this.rewards.add(QuestRewardTable.POTION_INGREDIENTS, rewardWeights[1]);
        this.rewards.add(QuestRewardTable.POTION, rewardWeights[2]);
        this.rewards.add(QuestRewardTable.COMBO_POTION, rewardWeights[3]);
    }

    public Component getTooltipText() {
        return new TranslatableComponent("tooltip." + this.name().toLowerCase(Locale.ROOT)).m_130940_(this.vanillaRarity.f_43022_);
    }

    public static QuestRarity getRarityFromPoints(float points) {
        for (int i = QuestRarity.values().length - 1; i >= 0; --i) {
            if (!(points >= (float)QuestRarity.values()[i].requiredPoints)) continue;
            return QuestRarity.values()[i];
        }
        return COMMON;
    }

    public static QuestRarity getRarityFromQuest(WitchQuest quest) {
        return QuestRarity.getRarityFromPoints(quest.getPoints());
    }
}

