/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.crafting.AltarMenu;

public class AltarScreen
extends AbstractContainerScreen<AltarMenu> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/gui/altar.png");
    private static final int[] GYLPH_PROGRESS = new int[]{0, 6, 11, 16, 20, 24, 29, 35, 42, 49, 54, 54, 54};
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private BookModel bookModel;
    private final Random random = new Random();
    public int ticks;
    public float nextPageAngle;
    public float pageAngle;
    public float approximatePageAngle;
    public float pageRotationSpeed;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    private ItemStack stack = ItemStack.f_41583_;

    public AltarScreen(AltarMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.bookModel = new BookModel(this.f_96541_.m_167973_().m_171103_(ModelLayers.f_171271_));
    }

    protected void m_7286_(PoseStack poseStack, float delta, int mouseX, int mouseY) {
        Lighting.m_84930_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int progress = ((AltarMenu)this.m_6262_()).getProgress();
        float progressPerc = (float)progress / 300.0f;
        if (progress > 0) {
            int n = (int)(28.0f * (1.0f - (float)progress / 300.0f));
            if (n > 0) {
                int perc = (int)(progressPerc * 29.0f);
                this.m_93228_(poseStack, x + 99, y + 55 - perc, 189, 29 - perc, 9, perc);
            }
            if ((n = GYLPH_PROGRESS[progress / 2 % 13]) > 0) {
                this.m_93228_(poseStack, x + 68, y + 16 + 53 - n, 177, 53 - n, 12, n);
            }
        }
        int m = (int)this.f_96541_.m_91268_().m_85449_();
        RenderSystem.m_69949_((int)((this.f_96543_ - 320) / 2 * m), (int)((this.f_96544_ - 240) / 2 * m), (int)(320 * m), (int)(240 * m));
        Matrix4f matrix4f = Matrix4f.m_27653_((float)-0.34f, (float)0.23f, (float)0.0f);
        matrix4f.m_27644_(Matrix4f.m_27625_((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        pose.m_85861_().m_27624_();
        pose.m_85864_().m_8180_();
        poseStack.m_85837_(0.0, 2.0, 1984.0);
        float scale = 5.0f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
        float h = Mth.m_14179_((float)delta, (float)this.pageTurningSpeed, (float)this.nextPageTurningSpeed);
        poseStack.m_85837_((double)((1.0f - h) * 0.2f), (double)((1.0f - h) * 0.1f), (double)((1.0f - h) * 0.25f));
        float n = -(1.0f - h) * 90.0f - 90.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(n));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        float o = Mth.m_14179_((float)delta, (float)this.pageAngle, (float)this.nextPageAngle) + 0.25f;
        float p = Mth.m_14179_((float)delta, (float)this.pageAngle, (float)this.nextPageAngle) + 0.75f;
        o = (o - (float)Mth.m_14080_((double)o)) * 1.6f - 0.3f;
        p = (p - (float)Mth.m_14080_((double)p)) * 1.6f - 0.3f;
        if (o < 0.0f) {
            o = 0.0f;
        }
        if (p < 0.0f) {
            p = 0.0f;
        }
        if (o > 1.0f) {
            o = 1.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        this.bookModel.m_102292_(0.0f, o, p, h);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.bookModel.m_103119_(BOOK_TEXTURE));
        this.bookModel.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_69949_((int)0, (int)0, (int)this.f_96541_.m_91268_().m_85441_(), (int)this.f_96541_.m_91268_().m_85442_());
        RenderSystem.m_157424_();
        Lighting.m_84931_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.doTick();
    }

    public void doTick() {
        boolean bl;
        ItemStack itemStack = ((AltarMenu)this.m_6262_()).m_38853_(0).m_7993_();
        if (!ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)this.stack)) {
            this.stack = itemStack;
            do {
                this.approximatePageAngle += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.nextPageAngle <= this.approximatePageAngle + 1.0f && this.nextPageAngle >= this.approximatePageAngle - 1.0f);
        }
        ++this.ticks;
        this.pageAngle = this.nextPageAngle;
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        boolean bl2 = bl = ((AltarMenu)this.m_6262_()).getProgress() > 0;
        this.nextPageTurningSpeed = bl ? (this.nextPageTurningSpeed += 0.2f) : (this.nextPageTurningSpeed -= 0.2f);
        this.nextPageTurningSpeed = Mth.m_14036_((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        float f = (this.approximatePageAngle - this.nextPageAngle) * 0.4f;
        float range = 0.2f;
        f = Mth.m_14036_((float)f, (float)(-range), (float)range);
        this.pageRotationSpeed += (f - this.pageRotationSpeed) * 0.9f;
        this.nextPageAngle += this.pageRotationSpeed;
    }
}

