/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.AltarBlock;
import party.lemons.biomemakeover.crafting.AltarMenu;
import party.lemons.biomemakeover.init.BMBlockEntities;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.biomemakeover.util.effect.BiomeMakeoverEffect;
import party.lemons.biomemakeover.util.effect.EffectHelper;

public class AltarBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    public static final int MAX_TIME = 300;
    private static final double PI = Math.PI;
    private static final double PI2 = Math.PI * 2;
    private static final List<Enchantment> curses = Lists.newArrayList();
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private int progress = 0;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return AltarBlockEntity.this.progress;
        }

        public void m_8050_(int index, int value) {
            AltarBlockEntity.this.progress = value;
        }

        public int m_6499_() {
            return 1;
        }
    };
    public int ticks;
    public float nextPageAngle;
    public float pageAngle;
    public float nextPageTurn;
    public float angleChange;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float currentAngle;
    public float lastAngle;
    public float nextAngle;
    private static final Random RANDOM = new Random();
    private boolean workingPrevious = false;

    public AltarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BMBlockEntities.ALTAR.get(), blockPos, blockState);
    }

    private void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        ++this.ticks;
        this.updateBook();
        boolean working = false;
        if (this.canWork()) {
            if (!this.f_58857_.m_5776_()) {
                working = true;
                if (!this.workingPrevious) {
                    this.f_58857_.m_7731_(pos, (BlockState)this.f_58857_.m_8055_(pos).m_61124_((Property)AltarBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                    EffectHelper.doEffect(this.f_58857_, BiomeMakeoverEffect.PLAY_CURSE_SOUND, pos);
                }
                ++this.progress;
                if (this.progress >= 300) {
                    if (this.m_8020_(0).m_41720_() == Items.f_42517_) {
                        ItemStack newStack = new ItemStack((ItemLike)Items.f_42690_);
                        Enchantment curse = AltarBlockEntity.getRandomCurse(this.f_58857_.f_46441_);
                        if (curse == null) {
                            return;
                        }
                        newStack.m_41663_(curse, 1);
                        this.inventory.set(0, (Object)newStack);
                    } else if (!AltarBlockEntity.curseItemStack(this.m_8020_(0), this.f_58857_.f_46441_)) {
                        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)this.m_8020_(0).m_41777_());
                        this.m_8020_(0).m_41774_(1);
                    }
                    this.progress = 0;
                    this.m_8020_(1).m_41774_(1);
                }
            }
        } else if (!this.f_58857_.m_5776_()) {
            this.progress = 0;
            working = false;
            if (!this.workingPrevious) {
                this.f_58857_.m_7731_(pos, (BlockState)this.f_58857_.m_8055_(pos).m_61124_((Property)AltarBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        this.workingPrevious = working;
    }

    private void updateBook() {
        if (!this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos pos = this.m_58899_();
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        this.lastAngle = this.currentAngle;
        if (!this.f_58857_.m_8055_(pos).m_60713_(BMBlocks.ALTAR.get())) {
            return;
        }
        if (((Boolean)this.f_58857_.m_8055_(pos).m_61143_((Property)AltarBlock.ACTIVE)).booleanValue()) {
            this.nextAngle += 0.5f;
            this.nextPageTurningSpeed += 0.2f;
        } else {
            Player playerEntity = this.f_58857_.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
            if (playerEntity != null) {
                double distanceX = playerEntity.m_20185_() - ((double)pos.m_123341_() + 0.5);
                double distanceZ = playerEntity.m_20189_() - ((double)pos.m_123343_() + 0.5);
                this.nextAngle = (float)Mth.m_14136_((double)distanceZ, (double)distanceX);
                this.nextPageTurningSpeed += 0.1f;
                if (this.nextPageTurningSpeed < 0.5f || RANDOM.nextInt(40) == 0) {
                    float f = this.nextPageTurn;
                    do {
                        this.nextPageTurn += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                    } while (f == this.nextPageTurn);
                }
            } else {
                this.nextAngle += 0.02f;
                this.nextPageTurningSpeed -= 0.1f;
            }
        }
        while ((double)this.currentAngle >= Math.PI) {
            this.currentAngle = (float)((double)this.currentAngle - Math.PI * 2);
        }
        while ((double)this.currentAngle < -Math.PI) {
            this.currentAngle = (float)((double)this.currentAngle + Math.PI * 2);
        }
        while ((double)this.nextAngle >= Math.PI) {
            this.nextAngle = (float)((double)this.nextAngle - Math.PI * 2);
        }
        while ((double)this.nextAngle < -Math.PI) {
            this.nextAngle = (float)((double)this.nextAngle + Math.PI * 2);
        }
        float rotation = this.nextAngle - this.currentAngle;
        while ((double)rotation >= Math.PI) {
            rotation = (float)((double)rotation - Math.PI * 2);
        }
        while ((double)rotation < -Math.PI) {
            rotation = (float)((double)rotation + Math.PI * 2);
        }
        this.currentAngle += rotation * 0.4f;
        this.nextPageTurningSpeed = Mth.m_14036_((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++this.ticks;
        this.pageAngle = this.nextPageAngle;
        float h = (this.nextPageTurn - this.nextPageAngle) * 0.4f;
        h = Mth.m_14036_((float)h, (float)-0.2f, (float)0.2f);
        this.angleChange += (h - this.angleChange) * 0.9f;
        this.nextPageAngle += this.angleChange;
    }

    public boolean canWork() {
        return AltarBlockEntity.isValidForCurse((ItemStack)this.inventory.get(0)) && !((ItemStack)this.inventory.get(1)).m_41619_();
    }

    public static boolean isValidForCurse(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() instanceof EnchantedBookItem) {
            return false;
        }
        if (stack.m_41720_() == Items.f_42517_) {
            return true;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.isEmpty() || stack.m_41782_() && stack.m_41783_().m_128441_("BMCursed")) {
            return false;
        }
        boolean hasNewCompatibleCurse = false;
        for (Enchantment enchantment : enchantments.keySet()) {
            if (enchantment.m_6586_() > 1 && !enchantment.m_6589_()) {
                return true;
            }
            if (!enchantment.m_6589_() || !enchantment.m_6081_(stack) || enchantments.containsKey(enchantment)) continue;
            hasNewCompatibleCurse = true;
        }
        return hasNewCompatibleCurse;
    }

    public static Enchantment getRandomCurse(Random random) {
        if (curses.isEmpty()) {
            curses.addAll(Registry.f_122825_.m_123024_().filter(Enchantment::m_6589_).toList());
        }
        if (curses.isEmpty()) {
            return null;
        }
        return curses.get(random.nextInt(curses.size()));
    }

    public static boolean curseItemStack(ItemStack stack, Random random) {
        if (AltarBlockEntity.isValidForCurse(stack)) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            List<Enchantment> validEnchants = enchantments.keySet().stream().filter(e -> e.m_6586_() > 1 && !e.m_6589_()).toList();
            Enchantment toUpgrade = validEnchants.get(random.nextInt(validEnchants.size()));
            enchantments.put(toUpgrade, (Integer)enchantments.get(toUpgrade) + 1);
            Enchantment curse = AltarBlockEntity.getRandomCurse(random);
            if (curse == null) {
                return false;
            }
            int attempts = 0;
            while (enchantments.containsKey(curse) || !curse.m_6081_(stack)) {
                curse = AltarBlockEntity.getRandomCurse(random);
                if (curse == null) {
                    return false;
                }
                if (++attempts < 100) continue;
                curse = null;
                break;
            }
            if (curse == null) {
                for (Enchantment enchantment : Registry.f_122825_.m_123024_().sorted((e, e1) -> RandomUtil.randomRange(-1, 1)).collect(Collectors.toList())) {
                    if (!enchantment.m_6589_() || !enchantment.m_6081_(stack) || enchantments.containsKey(enchantment)) continue;
                    curse = enchantment;
                }
            }
            if (curse == null) {
                return false;
            }
            int curseLevel = curse.m_6586_() == 1 ? 1 : RandomUtil.randomRange(curse.m_44702_(), curse.m_6586_());
            enchantments.put(curse, curseLevel);
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("BMCursed", true);
            stack.m_41751_(tag);
            stack.m_41742_(39);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
            return true;
        }
        return false;
    }

    public int[] m_7071_(Direction direction) {
        if (direction.m_122434_() == Direction.Axis.Y) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        if (slot == 0 && AltarBlockEntity.isValidForCurse(stack)) {
            return true;
        }
        return slot == 1 && stack.m_204117_(BMItems.CURSE_FUEL);
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return true;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int i) {
        if (i < 0 || i >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack m_7407_(int i, int j) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.inventory, (int)i, (int)j);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int i) {
        ItemStack itemStack = (ItemStack)this.inventory.get(i);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.inventory.set(i, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        BlockPos pos = this.m_58899_();
        if (this.f_58857_.m_7702_(pos) != this) {
            return false;
        }
        return player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> nonNullList) {
        this.inventory = nonNullList;
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (lvl, pos, state, type) -> {
            BlockEntity be = lvl.m_7702_(pos);
            if (be != null && be instanceof AltarBlockEntity) {
                ((AltarBlockEntity)be).tick();
            }
        };
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.inventory);
        compoundTag.m_128405_("Progress", this.progress);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.inventory);
        this.progress = compoundTag.m_128451_("Progress");
    }

    protected Component m_6820_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new AltarMenu(i, inventory, (Container)this, this.data);
    }
}

