/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.BMBlock;
import party.lemons.biomemakeover.block.blockentity.PoltergeistBlockEntity;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.level.PoltergeistHandler;

public class PoltergeistBlock
extends BMBlock
implements EntityBlock {
    public static BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public PoltergeistBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PoltergeistBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return PoltergeistBlockEntity.getTicker(level, blockState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(!ctx.m_43725_().m_46753_(ctx.m_8083_())));
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        boolean currentlyEnabled;
        if (!level.m_5776_() && (currentlyEnabled = ((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) == level.m_46753_(blockPos)) {
            if (currentlyEnabled) {
                level.m_186460_(blockPos, (Block)this, 4);
            } else {
                level.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)ENABLED), 2);
                this.doToggleEffects(level, blockPos);
            }
        }
    }

    public void m_7458_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue() && serverLevel.m_46753_(blockPos)) {
            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)ENABLED), 2);
            this.doToggleEffects((Level)serverLevel, blockPos);
        }
    }

    private void doToggleEffects(Level world, BlockPos pos) {
        world.m_5594_(null, pos, BMEffects.POLTERGEIST_TOGGLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        PoltergeistHandler.doParticles(world, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED});
    }
}

