/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMAdvancements;

public class EctoplasmComposterBlock
extends ComposterBlock {
    public EctoplasmComposterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public WorldlyContainer m_5840_(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        int currentLevel = (Integer)blockState.m_61143_((Property)f_51913_);
        if (currentLevel == 8) {
            return new FullComposterContainer(levelAccessor, blockPos, new ItemStack((ItemLike)Items.f_42050_));
        }
        return super.m_5840_(blockState, levelAccessor, blockPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        int currentLevel = (Integer)state.m_61143_((Property)f_51913_);
        ItemStack itemStack = player.m_21120_(hand);
        if (currentLevel < 8 && f_51914_.containsKey((Object)itemStack.m_41720_())) {
            if (currentLevel < 7 && !level.m_5776_()) {
                BlockState blockState = EctoplasmComposterBlock.addItem(state, level, pos, itemStack);
                level.m_46796_(1500, pos, state != blockState ? 1 : 0);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (currentLevel == 8) {
            EctoplasmComposterBlock.emptyFullComposter(level, pos);
            if (!level.m_5776_()) {
                BMAdvancements.ECTOPLASM_COMPOST.trigger((ServerPlayer)player);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public static void emptyFullComposter(Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            float offset = 0.7f;
            double offsetX = (double)(level.f_46441_.nextFloat() * offset) + 0.15;
            double offsetY = (double)(level.f_46441_.nextFloat() * offset) + 0.06 + 0.6;
            double offsetZ = (double)(level.f_46441_.nextFloat() * offset) + 0.15;
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, new ItemStack((ItemLike)Blocks.f_50136_));
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        BlockState originalState = Blocks.f_50715_.m_49966_();
        level.m_7731_(pos, originalState, 3);
        level.m_5594_(null, pos, SoundEvents.f_11763_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static BlockState addItem(BlockState state, Level world, BlockPos pos, ItemStack item) {
        int currentLevel = (Integer)state.m_61143_((Property)f_51913_);
        float increaseChance = f_51914_.getFloat((Object)item.m_41720_());
        if ((currentLevel != 0 || increaseChance <= 0.0f) && world.m_5822_().nextDouble() >= (double)increaseChance) {
            return state;
        }
        int nextLevel = currentLevel + 1;
        BlockState blockState = (BlockState)state.m_61124_((Property)f_51913_, (Comparable)Integer.valueOf(nextLevel));
        world.m_7731_(pos, blockState, 3);
        if (nextLevel == 7) {
            world.m_186460_(pos, state.m_60734_(), 20);
        }
        return blockState;
    }

    static class FullComposterContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private boolean dirty = false;
        private LevelAccessor level;
        private BlockPos pos;

        public FullComposterContainer(LevelAccessor level, BlockPos pos, ItemStack stack) {
            super(new ItemStack[]{stack});
            this.level = level;
            this.pos = pos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction direction) {
            int[] nArray;
            if (direction == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
            return false;
        }

        public boolean m_7157_(int i, ItemStack itemStack, Direction dir) {
            return !this.dirty && dir == Direction.DOWN && itemStack.m_41720_() == Items.f_42050_;
        }

        public void m_6596_() {
            this.dirty = true;
            BlockState blockState = Blocks.f_50715_.m_49966_();
            this.level.m_7731_(this.pos, blockState, 3);
            super.m_6596_();
        }
    }
}

