/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlocks {
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"storagedrawers");
    public static final RegistryObject<BlockStandardDrawers> OAK_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("oak_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> OAK_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("oak_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> OAK_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("oak_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> OAK_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("oak_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> OAK_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("oak_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> OAK_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("oak_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("spruce_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("spruce_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("spruce_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("spruce_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("spruce_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("spruce_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> BIRCH_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("birch_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> BIRCH_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("birch_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> BIRCH_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("birch_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> BIRCH_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("birch_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> BIRCH_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("birch_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> BIRCH_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("birch_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("jungle_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("jungle_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("jungle_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("jungle_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("jungle_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("jungle_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> ACACIA_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("acacia_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> ACACIA_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("acacia_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> ACACIA_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("acacia_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> ACACIA_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("acacia_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> ACACIA_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("acacia_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> ACACIA_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("acacia_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("dark_oak_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("dark_oak_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("dark_oak_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("dark_oak_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("dark_oak_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("dark_oak_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("crimson_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("crimson_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("crimson_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("crimson_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("crimson_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("crimson_half_drawers_4", 4, true);
    public static final RegistryObject<BlockStandardDrawers> WARPED_FULL_DRAWERS_1 = ModBlocks.registerDrawerBlock("warped_full_drawers_1", 1, false);
    public static final RegistryObject<BlockStandardDrawers> WARPED_FULL_DRAWERS_2 = ModBlocks.registerDrawerBlock("warped_full_drawers_2", 2, false);
    public static final RegistryObject<BlockStandardDrawers> WARPED_FULL_DRAWERS_4 = ModBlocks.registerDrawerBlock("warped_full_drawers_4", 4, false);
    public static final RegistryObject<BlockStandardDrawers> WARPED_HALF_DRAWERS_1 = ModBlocks.registerDrawerBlock("warped_half_drawers_1", 1, true);
    public static final RegistryObject<BlockStandardDrawers> WARPED_HALF_DRAWERS_2 = ModBlocks.registerDrawerBlock("warped_half_drawers_2", 2, true);
    public static final RegistryObject<BlockStandardDrawers> WARPED_HALF_DRAWERS_4 = ModBlocks.registerDrawerBlock("warped_half_drawers_4", 4, true);
    public static final RegistryObject<BlockCompDrawers> COMPACTING_DRAWERS_3 = ModBlocks.registerCompactingDrawerBlock("compacting_drawers_3");
    public static final RegistryObject<BlockTrim> OAK_TRIM = ModBlocks.registerTrimBlock("oak_trim");
    public static final RegistryObject<BlockTrim> SPRUCE_TRIM = ModBlocks.registerTrimBlock("spruce_trim");
    public static final RegistryObject<BlockTrim> BIRCH_TRIM = ModBlocks.registerTrimBlock("birch_trim");
    public static final RegistryObject<BlockTrim> JUNGLE_TRIM = ModBlocks.registerTrimBlock("jungle_trim");
    public static final RegistryObject<BlockTrim> ACACIA_TRIM = ModBlocks.registerTrimBlock("acacia_trim");
    public static final RegistryObject<BlockTrim> DARK_OAK_TRIM = ModBlocks.registerTrimBlock("dark_oak_trim");
    public static final RegistryObject<BlockTrim> CRIMSON_TRIM = ModBlocks.registerTrimBlock("crimson_trim");
    public static final RegistryObject<BlockTrim> WARPED_TRIM = ModBlocks.registerTrimBlock("warped_trim");
    public static final RegistryObject<BlockController> CONTROLLER = ModBlocks.registerControllerBlock("controller");
    public static final RegistryObject<BlockSlave> CONTROLLER_SLAVE = ModBlocks.registerControllerSlaveBlock("controller_slave");

    private ModBlocks() {
    }

    private static RegistryObject<BlockStandardDrawers> registerDrawerBlock(String name, int drawerCount, boolean halfDepth) {
        return BLOCK_REGISTER.register(name, () -> new BlockStandardDrawers(drawerCount, halfDepth, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56736_).m_60960_(ModBlocks::predFalse).m_60924_(ModBlocks::predFalse)));
    }

    private static RegistryObject<BlockCompDrawers> registerCompactingDrawerBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockCompDrawers(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(10.0f).m_60960_(ModBlocks::predFalse).m_60924_(ModBlocks::predFalse)));
    }

    private static RegistryObject<BlockTrim> registerTrimBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockTrim(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(5.0f)));
    }

    private static RegistryObject<BlockController> registerControllerBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockController(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56742_).m_60978_(5.0f)));
    }

    private static RegistryObject<BlockSlave> registerControllerSlaveBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockSlave(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56742_).m_60978_(5.0f)));
    }

    public static void register(IEventBus bus) {
        BLOCK_REGISTER.register(bus);
    }

    public static <B extends Block> Stream<B> getBlocksOfType(Class<B> blockClass) {
        return BLOCK_REGISTER.getEntries().stream().filter(RegistryObject::isPresent).map(RegistryObject::get).filter(blockClass::isInstance).map(blockClass::cast);
    }

    public static Stream<BlockDrawers> getDrawers() {
        return ModBlocks.getBlocksOfType(BlockDrawers.class);
    }

    public static <B extends BlockDrawers> Stream<B> getDrawersOfTypeAndSize(Class<B> drawerClass, int size) {
        return ModBlocks.getBlocksOfType(drawerClass).filter(blockStandardDrawers -> blockStandardDrawers.getDrawerCount() == size);
    }

    public static <B extends BlockDrawers> Stream<B> getDrawersOfTypeAndSizeAndDepth(Class<B> drawerClass, int size, boolean halfDepth) {
        return ModBlocks.getDrawersOfTypeAndSize(drawerClass, size).filter(blockStandardDrawers -> blockStandardDrawers.isHalfDepth() == halfDepth);
    }

    private static boolean predFalse(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }
}

