/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.capabilities;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public interface IItemRepository {
    @Nonnull
    public NonNullList<ItemRecord> getAllItems();

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack var1, boolean var2, Predicate<ItemStack> var3);

    @Nonnull
    default public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, null);
    }

    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack var1, int var2, boolean var3, Predicate<ItemStack> var4);

    @Nonnull
    default public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate) {
        return this.extractItem(stack, amount, simulate, null);
    }

    default public int getStoredItemCount(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        ItemStack amount = this.extractItem(stack, Integer.MAX_VALUE, true, predicate);
        return amount.m_41613_();
    }

    default public int getStoredItemCount(@Nonnull ItemStack stack) {
        return this.getStoredItemCount(stack, null);
    }

    default public int getRemainingItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        stack = stack.m_41777_();
        stack.m_41764_(Integer.MAX_VALUE);
        ItemStack remainder = this.insertItem(stack, true, predicate);
        return Integer.MAX_VALUE - remainder.m_41613_();
    }

    default public int getRemainingItemCapacity(@Nonnull ItemStack stack) {
        return this.getRemainingItemCapacity(stack, null);
    }

    default public int getItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        long capacity = this.getStoredItemCount(stack, predicate) + this.getRemainingItemCapacity(stack, predicate);
        if (capacity > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    default public int getItemCapacity(@Nonnull ItemStack stack) {
        return this.getItemCapacity(stack, null);
    }

    public static interface DefaultPredicate<T>
    extends Predicate<T> {
    }

    public static class ItemRecord {
        @Nonnull
        public final ItemStack itemPrototype;
        public final int count;

        public ItemRecord(@Nonnull ItemStack itemPrototype, int count) {
            this.itemPrototype = itemPrototype;
            this.count = count;
        }
    }
}

