/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomDataHolder;
import net.mehvahdjukaar.selene.map.CustomMapDecoration;
import net.mehvahdjukaar.selene.map.client.MapDecorationRenderHandler;
import net.mehvahdjukaar.selene.map.markers.MapBlockMarker;
import net.mehvahdjukaar.selene.map.type.CustomDecorationType;
import net.mehvahdjukaar.selene.map.type.IMapDecorationType;
import net.mehvahdjukaar.selene.map.type.SimpleDecorationType;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;

public class MapDecorationRegistry
extends SimpleJsonResourceReloadListener {
    private final List<SimpleDecorationType> dynamicTypes = new ArrayList<SimpleDecorationType>();
    public static final MapDecorationRegistry DATA_DRIVEN_REGISTRY = new MapDecorationRegistry();
    public static final Map<ResourceLocation, CustomDataHolder<?>> CUSTOM_MAP_DATA_TYPES = new HashMap();
    private static final Map<ResourceLocation, IMapDecorationType<? extends CustomMapDecoration, ?>> DECORATION_TYPES = new HashMap();

    public MapDecorationRegistry() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "map_markers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dynamicTypes.forEach(t -> DECORATION_TYPES.remove(t.getId()));
        this.dynamicTypes.clear();
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            Optional result = SimpleDecorationType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)j.getValue()).resultOrPartial(e -> Selene.LOGGER.error("Failed to parse Map Decoration JSON object for {} : {}", j.getKey(), e));
            if (!result.isPresent()) continue;
            this.dynamicTypes.add((SimpleDecorationType)result.get());
            MapDecorationRegistry.register((IMapDecorationType)result.get());
        }
    }

    public void acceptClientTypes(Collection<SimpleDecorationType> serverTypes) {
        for (SimpleDecorationType old : this.dynamicTypes) {
            MapDecorationRenderHandler.unbindRenderer(old);
            DECORATION_TYPES.remove(old.getId());
        }
        this.dynamicTypes.clear();
        for (SimpleDecorationType type : serverTypes) {
            this.dynamicTypes.add(type);
            MapDecorationRegistry.register(type);
            MapDecorationRenderHandler.bindSimpleRenderer(type);
        }
    }

    public Collection<SimpleDecorationType> getTypes() {
        return this.dynamicTypes;
    }

    public static <T extends CustomMapDecoration> void register(IMapDecorationType<T, ?> newType) {
        ResourceLocation id = newType.getId();
        if (DECORATION_TYPES.containsKey(id)) {
            DECORATION_TYPES.put(id, newType);
            Selene.LOGGER.error("Duplicate Map Marker registration: {}. This might be unwanted", (Object)id);
        } else {
            DECORATION_TYPES.put(id, newType);
        }
    }

    public static void registerSimple(String modId, String name) {
        MapDecorationRegistry.register(MapDecorationRegistry.makeSimpleType(modId, name));
    }

    public static CustomDecorationType<CustomMapDecoration, ?> makeSimpleType(String modId, String name) {
        return new CustomDecorationType(new ResourceLocation(modId, name), CustomMapDecoration::new);
    }

    @Nullable
    public static IMapDecorationType<?, ?> get(ResourceLocation id) {
        return DECORATION_TYPES.get(id);
    }

    @Nullable
    public static IMapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDecorationRegistry.get(new ResourceLocation(id));
    }

    @Nullable
    @ApiStatus.Internal
    public static MapBlockMarker<?> readWorldMarker(CompoundTag compound) {
        for (ResourceLocation id : DECORATION_TYPES.keySet()) {
            String s = id.toString();
            if (!compound.m_128441_(s)) continue;
            return DECORATION_TYPES.get(id).loadMarkerFromNBT(compound.m_128469_(s));
        }
        return null;
    }

    @ApiStatus.Internal
    public static List<MapBlockMarker<?>> getMarkersFromWorld(BlockGetter reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (IMapDecorationType<CustomMapDecoration, ?> type : DECORATION_TYPES.values()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }

    public static <T> void registerCustomMapSavedData(ResourceLocation name, Class<T> type, Function<CompoundTag, T> load, BiConsumer<CompoundTag, T> save, PropertyDispatch.TriFunction<MapItemSavedData, Entity, T, Boolean> onItemUpdate, PropertyDispatch.TriFunction<MapItemSavedData, ItemStack, T, Component> onItemTooltip) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey("name")) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + name);
        }
        CUSTOM_MAP_DATA_TYPES.put(name, new CustomDataHolder<T>(name, load, save, onItemUpdate, onItemTooltip));
    }
}

