/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids;

import java.util.function.Supplier;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.minecraft.resources.ResourceLocation;

public class FluidReference
implements Supplier<SoftFluid> {
    private final Object lock = new Object();
    private SoftFluid value = null;
    private final ResourceLocation id;
    private int reloadNumber = -1;

    public static FluidReference of(SoftFluid instance) {
        return new FluidReference(instance.getRegistryName());
    }

    public static FluidReference of(String name) {
        return new FluidReference(new ResourceLocation(name));
    }

    public static FluidReference of(ResourceLocation name) {
        return new FluidReference(name);
    }

    private FluidReference(ResourceLocation id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoftFluid get() {
        int n = SoftFluidRegistry.INSTANCE.currentReload;
        if (n == 0) {
            return SoftFluidRegistry.EMPTY;
        }
        Object object = this.lock;
        synchronized (object) {
            if (n != this.reloadNumber) {
                this.reloadNumber = SoftFluidRegistry.INSTANCE.currentReload;
                this.value = SoftFluidRegistry.get(this.id);
                if (this.value.isEmpty()) {
                    // empty if block
                }
            }
            return this.value;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean is(SoftFluid softFluid) {
        return this.get() == softFluid;
    }

    public boolean is(FluidReference softFluid) {
        return this.get() == softFluid.get();
    }
}

