/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.blocks;

import javax.annotation.Nonnull;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends WaterBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabType.class);

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return state.m_61143_(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(rot.m_55954_(((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).direction))));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        VerticalSlabType type = (VerticalSlabType)((Object)state.m_61143_(TYPE));
        if (type == VerticalSlabType.DOUBLE || mirrorIn == Mirror.NONE) {
            return state;
        }
        if (mirrorIn == Mirror.LEFT_RIGHT && type.direction.m_122434_() == Direction.Axis.Z || mirrorIn == Mirror.FRONT_BACK && type.direction.m_122434_() == Direction.Axis.X) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).direction.m_122424_())));
        }
        return state;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).shape;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(this.getDirectionForPlacement(context))));
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            return direction;
        }
        BlockPos pos = context.m_8083_();
        Vec3 vec = context.m_43720_().m_82546_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_82492_(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.f_82479_, vec.f_82481_) * -180.0 / Math.PI;
        return Direction.m_122364_((double)angle).m_122424_();
    }

    public boolean m_6864_(BlockState state, @Nonnull BlockPlaceContext context) {
        VerticalSlabType type = (VerticalSlabType)((Object)state.m_61143_(TYPE));
        return type != VerticalSlabType.DOUBLE && context.m_43722_().m_41720_() == this.m_5456_() && (context.m_7058_() && context.m_43719_() == type.direction && this.getDirectionForPlacement(context) == type.direction || !context.m_7058_() && context.m_43719_().m_122434_() != type.direction.m_122434_());
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        @Nullable
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.direction = direction;
            String string2 = this.name = direction == null ? "double" : direction.m_7912_();
            if (direction == null) {
                this.shape = Shapes.m_83144_();
            } else {
                boolean isNegativeAxis = direction.m_122421_() == Direction.AxisDirection.NEGATIVE;
                double min = isNegativeAxis ? 8.0 : 0.0;
                double max = isNegativeAxis ? 16.0 : 8.0;
                this.shape = direction.m_122434_() == Direction.Axis.X ? Block.m_49796_((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.m_49796_((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

