/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.minecraftforge.common.ForgeConfigSpec;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigs
implements IMixinConfigPlugin {
    public static List<String> getMixinClassesNames() {
        try {
            String className = MixinConfigs.class.getName();
            String packageName = MixinConfigs.class.getPackage().getName();
            return MixinConfigs.getClassesInPackage(packageName).stream().filter(s -> !s.equals(className)).map(s -> s.substring(packageName.length() + 1)).collect(Collectors.toList());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Could not fetch mixin classes, giving up: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private static List<String> getClassesInPackage(String packageName) throws IOException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replaceAll("[.]", "/");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        try {
            URL classLoaderResource = classLoader.getResource(path);
            assert (classLoaderResource != null);
            File dir = new File(classLoaderResource.toURI().toURL().getFile());
            dirs.add(dir);
        }
        catch (Exception classLoaderResource) {
            // empty catch block
        }
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (File directory : dirs) {
            classes.addAll(MixinConfigs.findClasses(directory, packageName));
        }
        return classes;
    }

    public static List<String> getClassesInPackage2(String packageName) throws IOException, URISyntaxException {
        String path = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        ArrayList<String> classes = new ArrayList<String>();
        URL classLoaderResource = classLoader.getResource(path);
        if (classLoaderResource == null) {
            throw new IOException("Could not create class loader resource URL for package: " + packageName);
        }
        File dir = new File(classLoaderResource.toURI());
        classes.addAll(MixinConfigs.findClasses(dir, packageName));
        return classes.stream().distinct().collect(Collectors.toList());
    }

    private static List<String> findClasses(File directory, String packageName) {
        File[] files;
        ArrayList<String> classes = new ArrayList<String>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(MixinConfigs.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + "." + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    public List<String> findAllClassesUsingClassLoader(String packageName) {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        List classes = reader.lines().filter(line -> line.endsWith(".class")).map(line -> this.getClass((String)line, packageName)).collect(Collectors.toList());
        return classes.stream().map(Class::getName).collect(Collectors.toList());
    }

    private Class getClass(String className, String packageName) {
        try {
            return Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void onLoad(String mixinPackage) {
        try {
            RegistryConfigs.createSpec();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create registry configs: " + exception);
        }
        try {
            RegistryConfigs.load();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load config supplementaries-registry.toml. Try deleting it");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String truncatedName = mixinClassName.substring(this.getClass().getPackage().getName().length() + 1);
        ForgeConfigSpec.BooleanValue config = RegistryConfigs.Reg.MIXIN_VALUES.get(truncatedName);
        return config == null || (Boolean)config.get() != false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

