/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSendKnockbackPacket
implements NetworkHandler.Message {
    public final int id;
    public final double knockbackX;
    public final double knockbackY;
    public final double knockbackZ;

    public ClientBoundSendKnockbackPacket(Vec3 knockback, int id) {
        this.id = id;
        this.knockbackX = knockback.f_82479_;
        this.knockbackY = knockback.f_82480_;
        this.knockbackZ = knockback.f_82481_;
    }

    public static void buffer(ClientBoundSendKnockbackPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.id);
        buf.writeDouble(pkt.knockbackX);
        buf.writeDouble(pkt.knockbackY);
        buf.writeDouble(pkt.knockbackZ);
    }

    public ClientBoundSendKnockbackPacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.knockbackX = buf.readDouble();
        this.knockbackY = buf.readDouble();
        this.knockbackZ = buf.readDouble();
    }

    public static void handler(ClientBoundSendKnockbackPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ClientReceivers.handleSendBombKnockbackPacket(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

