/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherHeadBlock;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpringLauncherArmBlockTile
extends BlockEntity {
    public int age;
    private double increment;
    public double offset;
    public double prevOffset;
    private int dx;
    private int dy;
    private int dz;

    public SpringLauncherArmBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.SPRING_LAUNCHER_ARM_TILE.get(), pos, state);
        boolean extending = (Boolean)state.m_61143_((Property)BlockProperties.EXTENDING);
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.age = 0;
        if (extending) {
            this.increment = 0.5;
            this.offset = -1.0;
            this.prevOffset = -1.0;
        } else {
            this.increment = -0.5;
            this.offset = 0.0;
            this.prevOffset = 0.0;
        }
        Vec3i v = dir.m_122436_();
        this.dx = v.m_123341_();
        this.dy = v.m_123342_();
        this.dz = v.m_123343_();
    }

    public AABB getAdjustedBoundingBox() {
        return new AABB(this.f_58858_).m_82386_((double)this.dx * this.offset, (double)this.dy * this.offset, (double)this.dz * this.offset);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpringLauncherArmBlockTile tile) {
        boolean extending = (Boolean)state.m_61143_((Property)SpringLauncherArmBlock.EXTENDING);
        if (level.f_46443_ && extending) {
            double x = (double)pos.m_123341_() + 0.5 + (double)tile.dx * tile.offset;
            double y = (double)pos.m_123342_() + (double)tile.dy * tile.offset;
            double z = (double)pos.m_123343_() + 0.5 + (double)tile.dz * tile.offset;
            Random random = level.f_46441_;
            for (int l = 0; l < 2; ++l) {
                double d0 = x + (double)random.nextFloat() - 0.5;
                double d1 = y + (double)random.nextFloat() + 0.5;
                double d2 = z + (double)random.nextFloat() - 0.5;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.05;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.05;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.05;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, d0, d1, d2, d3, d4, d5);
            }
        }
        if (tile.age > 1) {
            tile.prevOffset = tile.offset;
            if (!level.f_46443_) {
                Direction dir = (Direction)state.m_61143_((Property)SpringLauncherArmBlock.FACING);
                if (extending) {
                    BlockState state1 = ((Block)ModRegistry.SPRING_LAUNCHER_HEAD.get()).m_49966_();
                    level.m_7731_(pos, (BlockState)state1.m_61124_((Property)SpringLauncherHeadBlock.FACING, (Comparable)dir), 3);
                } else {
                    BlockState _bs = ((Block)ModRegistry.SPRING_LAUNCHER.get()).m_49966_();
                    BlockPos behindPos = pos.m_142300_(tile.getDirection().m_122424_());
                    BlockState oldState = level.m_8055_(behindPos);
                    if (((BlockState)_bs.m_61124_((Property)SpringLauncherBlock.FACING, (Comparable)dir)).m_61124_((Property)SpringLauncherBlock.EXTENDED, (Comparable)Boolean.valueOf(true)) == oldState) {
                        level.m_7731_(behindPos, (BlockState)oldState.m_61124_((Property)SpringLauncherBlock.EXTENDED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        } else {
            AABB p_bb;
            List list1;
            ++tile.age;
            tile.prevOffset = tile.offset;
            tile.offset += tile.increment;
            if (extending && !(list1 = level.m_45933_(null, p_bb = tile.getAdjustedBoundingBox())).isEmpty()) {
                for (Entity entity2 : list1) {
                    if (entity2.m_7752_() == PushReaction.IGNORE) continue;
                    Vec3 vec3d = entity2.m_20184_();
                    double d1 = vec3d.f_82479_;
                    double d2 = vec3d.f_82480_;
                    double d3 = vec3d.f_82481_;
                    double speed = ServerConfigs.cached.LAUNCHER_VEL;
                    if (tile.dx != 0) {
                        d1 = (double)tile.dx * speed;
                    }
                    if (tile.dy != 0) {
                        d2 = (double)tile.dy * speed;
                    }
                    if (tile.dz != 0) {
                        d3 = (double)tile.dz * speed;
                    }
                    entity2.m_20334_(d1, d2, d3);
                    entity2.f_19864_ = true;
                    tile.moveCollidedEntity(entity2, p_bb);
                }
            }
        }
    }

    private void moveCollidedEntity(Entity entity2, AABB p_bb) {
        AABB e_bb = entity2.m_142469_();
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        switch (this.getDirection()) {
            default: {
                dy = 0.0;
                break;
            }
            case UP: {
                dy = p_bb.f_82292_ - e_bb.f_82289_;
                break;
            }
            case DOWN: {
                dy = p_bb.f_82289_ - e_bb.f_82292_;
                break;
            }
            case NORTH: {
                dz = p_bb.f_82290_ - e_bb.f_82293_;
                break;
            }
            case SOUTH: {
                dz = p_bb.f_82293_ - e_bb.f_82290_;
                break;
            }
            case WEST: {
                dx = p_bb.f_82288_ - e_bb.f_82291_;
                break;
            }
            case EAST: {
                dx = p_bb.f_82291_ - e_bb.f_82288_;
            }
        }
        entity2.m_6478_(MoverType.PISTON, new Vec3(dx, dy, dz));
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)SpringLauncherArmBlock.FACING);
    }

    public boolean getExtending() {
        return (Boolean)this.m_58900_().m_61143_((Property)SpringLauncherArmBlock.EXTENDING);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.age = compound.m_128451_("Age");
        this.offset = compound.m_128459_("Offset");
        this.prevOffset = compound.m_128459_("PrevOffset");
        this.increment = compound.m_128459_("Increment");
        this.dx = compound.m_128451_("Dx");
        this.dy = compound.m_128451_("Dy");
        this.dz = compound.m_128451_("Dz");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Age", this.age);
        compound.m_128347_("Offset", this.offset);
        compound.m_128347_("PrevOffset", this.prevOffset);
        compound.m_128347_("Increment", this.increment);
        compound.m_128405_("Dx", this.dx);
        compound.m_128405_("Dy", this.dy);
        compound.m_128405_("Dz", this.dz);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

