/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.selene.fluids.ISoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GobletBlockTile
extends BlockEntity
implements ISoftFluidHolder,
IOwnerProtected {
    private UUID owner = null;
    public SoftFluidHolder fluidHolder;

    public GobletBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.GOBLET_TILE.get(), pos, state);
        int CAPACITY = 1;
        this.fluidHolder = new SoftFluidHolder(CAPACITY);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        int light = this.fluidHolder.getFluid().get().getLuminosity();
        if (light != (Integer)this.m_58900_().m_61143_((Property)BlockProperties.LIGHT_LEVEL_0_15)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        super.m_6596_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean handleInteraction(Player player, InteractionHand hand) {
        if (this.fluidHolder.interactWithPlayer(player, hand, this.f_58857_, this.f_58858_)) {
            return true;
        }
        if (!player.m_6144_() && ServerConfigs.cached.GOBLET_DRINK) {
            boolean b = this.fluidHolder.tryDrinkUpFluid(player, this.f_58857_);
            if (b && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Advancement advancement = this.f_58857_.m_142572_().m_129889_().m_136041_(new ResourceLocation("supplementaries:nether/goblet"));
                if (advancement != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "unlock");
                }
            }
            return b;
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.fluidHolder.load(compound);
        this.loadOwner(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidHolder.save(tag);
        this.saveOwner(tag);
    }

    public SoftFluidHolder getSoftFluidHolder() {
        return this.fluidHolder;
    }
}

