/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GlobeBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public GlobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        this.updatePower(state, worldIn, pos);
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            tile.setCustomName(stack.m_41786_());
        }
    }

    public void updatePower(BlockState state, Level world, BlockPos pos) {
        boolean powered;
        boolean bl = powered = world.m_46755_(pos) > 0;
        if (powered != (Boolean)state.m_61143_((Property)TRIGGERED)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(powered)), 4);
            if (powered) {
                world.m_151555_(GameEvent.f_157798_, pos);
                world.m_7696_(pos, state.m_60734_(), 1, 0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            if (player.m_21120_(handIn).m_41720_() instanceof ShearsItem) {
                tile.toggleShearing();
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
                if (level.f_46443_) {
                    Minecraft.m_91087_().f_91061_.m_107355_(pos, state);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!level.f_46443_) {
                if (tile.yaw > 1500.0f && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Advancement advancement = level.m_142572_().m_129889_().m_136041_(new ResourceLocation("supplementaries", "adventure/globe"));
                    if (advancement != null) {
                        serverPlayer.m_8960_().m_135988_(advancement, "unlock");
                    }
                }
                level.m_142346_((Entity)player, GameEvent.f_157798_, pos);
                level.m_7696_(pos, state.m_60734_(), 1, 0);
            } else {
                player.m_5661_((Component)new TextComponent("X: " + pos.m_123341_() + ", Z: " + pos.m_123343_()), true);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (CommonUtil.FESTIVITY.isEarthDay() && worldIn.f_46443_) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            for (int l = 0; l < 1; ++l) {
                double d0 = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                double d1 = (double)y + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                double d2 = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, moving);
        this.updatePower(state, world, pos);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.DOWN && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !worldIn.m_46859_(pos.m_7495_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, TRIGGERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GlobeBlockTile(pPos, pState);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(eventID, eventParam);
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            if (tile.yaw != 0.0f) {
                return 15;
            }
            return tile.face / -90 + 1;
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockUtils.getTicker(pBlockEntityType, (BlockEntityType)ModRegistry.GLOBE_TILE.get(), GlobeBlockTile::tick);
    }
}

