/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import java.util.TreeMap;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FeatherBlock
extends Block {
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private static final TreeMap<Float, VoxelShape> COLLISIONS = new TreeMap<Float, VoxelShape>(){
        {
            float y;
            float i = 0.0015f;
            this.put(Float.valueOf(y - i), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)y, (double)1.0));
            for (y = (float)COLLISION_SHAPE.m_83297_(Direction.Axis.Y); y < 1.0f; y += i) {
                this.put(Float.valueOf(y), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)y, (double)1.0));
                i = (float)((double)i * 1.131);
            }
            this.put(Float.valueOf(1.0f), Shapes.m_83144_());
            this.put(Float.valueOf(0.0f), Shapes.m_83144_());
        }
    };
    private final VoxelShape COLLISION_CHECK_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.1, (double)16.0);

    public FeatherBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity2, float height) {
        if (!world.f_46443_) {
            if (height > 2.0f) {
                world.m_5594_(null, pos, SoundEvents.f_12640_, SoundSource.BLOCKS, 1.0f, 0.9f);
            }
        } else {
            int i = 0;
            while ((double)i < Math.min(6.0, (double)height * 0.8)) {
                Random random = world.m_5822_();
                double dy = Mth.m_14008_((double)(0.03 * (double)height / 7.0), (double)0.03, (double)0.055);
                world.m_7106_((ParticleOptions)ModRegistry.FEATHER_PARTICLE.get(), entity2.m_20185_() + this.r(random, 0.35), entity2.m_20186_(), entity2.m_20189_() + this.r(random, 0.35), this.r(random, 0.007), dy * 0.5, this.r(random, 0.007));
                ++i;
            }
        }
    }

    public void m_5548_(BlockGetter reader, Entity entity2) {
        entity2.m_20256_(entity2.m_20184_().m_82542_(1.0, 0.4, 1.0));
    }

    private boolean isColliding(Entity e, BlockPos pos) {
        if (e == null) {
            return false;
        }
        VoxelShape voxelshape = this.COLLISION_CHECK_SHAPE.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return Shapes.m_83157_((VoxelShape)voxelshape, (VoxelShape)Shapes.m_83064_((AABB)e.m_142469_()), (BooleanOp)BooleanOp.f_82689_);
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity2) {
        if (level.f_46443_ && (!(entity2 instanceof LivingEntity) || entity2.m_146900_().m_60713_((Block)this))) {
            boolean isMoving;
            Random random = level.m_5822_();
            boolean bl = isMoving = entity2.f_19790_ != entity2.m_20185_() || entity2.f_19792_ != entity2.m_20189_();
            if (isMoving && random.nextInt(10) == 0) {
                double dy = 0.005;
                level.m_7106_((ParticleOptions)ModRegistry.FEATHER_PARTICLE.get(), entity2.m_20185_() + this.r(random, 0.15), entity2.m_20186_(), entity2.m_20189_() + this.r(random, 0.15), 0.0, dy, 0.0);
            }
        }
    }

    private double r(Random random, double a) {
        return a * (double)(random.nextFloat() + random.nextFloat() - 1.0f);
    }

    public boolean m_49967_() {
        return true;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Float key;
        LivingEntity entity2;
        float dy;
        EntityCollisionContext entityCollisionContext;
        Entity e;
        if (collisionContext instanceof EntityCollisionContext && (e = (entityCollisionContext = (EntityCollisionContext)collisionContext).m_193113_()) instanceof LivingEntity && (dy = (float)((entity2 = (LivingEntity)e).m_20186_() - (double)blockPos.m_123342_())) > 0.0f && (key = COLLISIONS.lowerKey(Float.valueOf(dy))) != null) {
            return COLLISIONS.getOrDefault(key, COLLISION_SHAPE);
        }
        return Shapes.m_83144_();
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        SoundType soundtype = state.getSoundType((LevelReader)level, pos, null);
        level.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (level.f_46443_) {
            Random r = level.f_46441_;
            for (int i = 0; i < 10; ++i) {
                level.m_7106_((ParticleOptions)ModRegistry.FEATHER_PARTICLE.get(), (double)((float)pos.m_123341_() + r.nextFloat()), (double)((float)pos.m_123342_() + r.nextFloat()), (double)((float)pos.m_123343_() + r.nextFloat()), (0.5 - (double)r.nextFloat()) * 0.02, (0.5 - (double)r.nextFloat()) * 0.02, (0.5 - (double)r.nextFloat()) * 0.02);
            }
        }
    }
}

