/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.api;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public interface ICatchableMob {
    default public boolean canBeCaughtWithItem(Item item2) {
        return switch (item2.getRegistryName().toString()) {
            case "supplementaries:jar" -> this.canBeCaughtWithJar();
            case "supplementaries:cage" -> this.canBeCaughtWithCage();
            default -> false;
        };
    }

    default public boolean canBeCaughtWithJar() {
        return false;
    }

    default public boolean canBeCaughtWithCage() {
        return true;
    }

    default public float getHitBoxWidthIncrement() {
        return 0.0f;
    }

    default public float getHitBoxHeightIncrement() {
        return 0.0f;
    }

    default public int getLightLevel() {
        return 0;
    }

    default public void tickInsideContainer(Level world, BlockPos pos, float entityScale, CompoundTag entityData) {
    }

    default public InteractionResult onPlayerInteract(Level world, BlockPos pos, Player player, InteractionHand hand, CompoundTag entityData) {
        return InteractionResult.PASS;
    }

    default public boolean isFlyingMob(boolean waterlogged) {
        return this.isFlyingMob();
    }

    default public boolean isFlyingMob() {
        Entity entity2 = this.getEntity();
        return entity2.m_20068_() || entity2 instanceof FlyingAnimal || entity2.m_6090_() || entity2 instanceof WaterAnimal;
    }

    public Entity getEntity();

    default public boolean shouldHaveWater() {
        return false;
    }

    default public void onContainerWaterlogged(boolean waterlogged) {
    }

    default public void setContainerDimensions(float width, float height) {
    }
}

