/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver.packets;

import com.nyfaria.nyfsquiver.items.QuiverItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketRename {
    private final String name;

    public PacketRename(String name) {
        this.name = name;
    }

    public static PacketRename decode(FriendlyByteBuf buffer) {
        return new PacketRename(buffer.readBoolean() ? buffer.m_130136_(Short.MAX_VALUE) : null);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.name != null);
        if (this.name != null) {
            buffer.m_130070_(this.name);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        ServerPlayer player = contextSupplier.get().getSender();
        if (player != null) {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof QuiverItem)) {
                stack = player.m_21120_(InteractionHand.OFF_HAND);
            }
            if (stack.m_41619_() || !(stack.m_41720_() instanceof QuiverItem)) {
                return;
            }
            stack.m_41714_((Component)new TextComponent(this.name));
        }
    }
}

