/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.nyfaria.nyfsquiver.NyfsQuiver;
import com.nyfaria.nyfsquiver.cap.QuiverHolder;
import com.nyfaria.nyfsquiver.cap.QuiverHolderAttacher;
import com.nyfaria.nyfsquiver.events.ClientModEvents;
import com.nyfaria.nyfsquiver.init.EnchantmentInit;
import com.nyfaria.nyfsquiver.init.TagInit;
import com.nyfaria.nyfsquiver.items.QuiverContainer;
import com.nyfaria.nyfsquiver.items.QuiverInventory;
import com.nyfaria.nyfsquiver.items.QuiverType;
import com.nyfaria.nyfsquiver.tooltip.QuiverTooltip;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.antlr.v4.runtime.misc.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class QuiverItem
extends Item
implements ICurioItem,
Wearable {
    public QuiverType type;

    public QuiverItem(QuiverType type) {
        super(new Item.Properties().m_41487_(1).m_41491_(NyfsQuiver.ITEM_GROUP).m_41503_(type.getColumns() * type.getRows()));
        this.type = type;
    }

    public static QuiverInventory getInventory(ItemStack itemStack) {
        return QuiverHolderAttacher.getQuiverHolderUnwrap(itemStack).getInventory();
    }

    public static void useQuiver(ItemStack quiverStack, ServerPlayer player, ItemStack arrowStack) {
        if (EnchantmentHelper.m_44831_((ItemStack)quiverStack).containsKey(EnchantmentInit.QUINFINITY.get())) {
            int damage = QuiverItem.checkQuinfinityValue(arrowStack);
            if (quiverStack.m_41773_() + damage <= quiverStack.m_41776_()) {
                quiverStack.m_41629_(damage, player.f_19853_.f_46441_, player);
            }
        }
    }

    public static int checkQuinfinityValue(ItemStack arrowStack) {
        int damage = 16;
        if (arrowStack.m_150930_(Items.f_42737_)) {
            damage = 8;
        } else if (arrowStack.m_150930_(Items.f_42412_)) {
            damage = 1;
        }
        return damage;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    public int m_6473_() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            tooltip.add((Component)new TranslatableComponent("Hold \u00a7eShift\u00a77 for More Information"));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_()) {
            if (!worldIn.m_5776_() && stack.m_41720_() instanceof QuiverItem) {
                int bagSlot = handIn == InteractionHand.MAIN_HAND ? playerIn.m_150109_().f_35977_ : -1;
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new ContainerProvider(stack.m_41611_(), bagSlot, QuiverItem.getInventory(stack)), a -> {
                    a.writeInt(bagSlot);
                    a.writeInt(QuiverItem.getInventory((ItemStack)stack).rows);
                    a.writeInt(QuiverItem.getInventory((ItemStack)stack).columns);
                    a.m_130079_(QuiverItem.getInventory(stack).serializeNBT());
                });
            }
        } else if (worldIn.f_46443_) {
            ClientModEvents.openScreen(stack.m_41720_().m_7626_(stack).m_6111_(), stack.m_41611_().m_6111_());
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.f_46443_);
    }

    public boolean m_41475_() {
        return this.type.getFireProof();
    }

    public AbstractArrow modifyArrow(AbstractArrow abstractArrow) {
        return abstractArrow;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            if (QuiverItem.getInventory(itemStack) != null) {
                return Optional.of(new QuiverTooltip(QuiverItem.getInventory(itemStack).getStacks(), 64, this.type));
            }
        } else {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        QuiverHolderAttacher.getQuiverHolderUnwrap(stack).deserializeNBT(nbt.m_128469_("inventory"), true);
        super.readShareTag(stack, nbt);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.m_128365_("inventory", (Tag)QuiverHolderAttacher.getQuiverHolderUnwrap(stack).serializeNBT(true));
        return tag;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.type.getDefaultDurability();
    }

    public boolean m_142305_(ItemStack quiverStack, ItemStack inputItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction == ClickAction.SECONDARY && inputItem.m_204117_(TagInit.QUIVER_ITEMS) && !quiverStack.m_41619_()) {
            QuiverInventory qi = QuiverItem.getInventory(quiverStack);
            int slots = qi.getSlots();
            for (int s = 0; s < slots; ++s) {
                ItemStack currentStack = qi.getStackInSlot(s);
                ItemStack rem2 = inputItem.m_41777_();
                if (currentStack.m_41720_() == inputItem.m_41720_() || currentStack.m_41619_()) {
                    rem2 = qi.insertItem(s, rem2, false);
                }
                inputItem.m_41764_(rem2.m_41613_());
            }
            return true;
        }
        return false;
    }

    public boolean m_41465_() {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        if (EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(EnchantmentInit.CYCLING.get())) {
            QuiverHolder quiverHolder = QuiverHolderAttacher.getQuiverHolderUnwrap(stack);
            if (QuiverItem.getInventory(stack).getStacks().stream().filter(is -> !is.m_41619_()).count() > 0L && QuiverItem.getInventory(stack).getStackInSlot(quiverHolder.getCurrentSlot()).m_41619_()) {
                quiverHolder.changeCurrentSlot(1);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (stack.m_41773_() > 0 && !EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(EnchantmentInit.QUINFINITY.get())) {
            stack.m_41721_(0);
        }
    }

    public static class ContainerProvider
    implements MenuProvider {
        private final Component displayName;
        private final int bagSlot;
        private final QuiverInventory inventory;

        public ContainerProvider(Component displayName, int bagSlot, QuiverInventory inventory) {
            this.displayName = displayName;
            this.bagSlot = bagSlot;
            this.inventory = inventory;
        }

        @NotNull
        public Component m_5446_() {
            return this.displayName;
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInv, @NotNull Player player) {
            return new QuiverContainer(id, playerInv, this.bagSlot, this.inventory, this.inventory.rows, this.inventory.columns);
        }
    }
}

