/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver.items;

import com.nyfaria.nyfsquiver.init.TagInit;
import com.nyfaria.nyfsquiver.items.QuiverItem;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class QuiverInventory
extends ItemStackHandler {
    private final boolean remote;
    public int rows;
    public int columns;
    private final NonNullList<ItemStack> stacks;

    public QuiverInventory(boolean remote, int rows, int columns) {
        this.remote = remote;
        this.rows = rows;
        this.columns = columns;
        this.stacks = NonNullList.m_122780_((int)(this.rows * this.columns), (Object)ItemStack.f_41583_);
    }

    private static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41619_() || stack2.m_41619_() || stack1.m_41720_() == stack2.m_41720_() && stack1.m_41773_() == stack2.m_41773_() && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public int getSlots() {
        return this.rows * this.columns;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        for (int x = 0; x < this.getSlots(); ++x) {
            if (!this.getStackInSlot(x).m_150930_(stack.m_41720_()) || this.getStackInSlot(x).m_41613_() >= 64) continue;
            return this.insertItem(x, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack current = (ItemStack)this.stacks.get(slot);
        if (!stack.m_41619_() && this.isItemValid(slot, stack) && QuiverInventory.canStack(current, stack)) {
            int amount = Math.min(stack.m_41613_(), 64 - current.m_41613_());
            if (!simulate) {
                ItemStack newStack = stack.m_41777_();
                newStack.m_41764_(current.m_41613_() + amount);
                this.stacks.set(slot, (Object)newStack);
            }
            ItemStack result = stack.m_41777_();
            result.m_41774_(amount);
            return result;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        int count = Math.min(amount, stack.m_41613_());
        ItemStack result = stack.m_41777_();
        if (!simulate) {
            stack.m_41774_(count);
            if (!this.remote && result.m_41720_() instanceof QuiverItem && result.m_41784_().m_128441_("invIndex")) {
                int index = result.m_41784_().m_128451_("invIndex");
                boolean contains = false;
                for (ItemStack stack1 : this.stacks) {
                    if (!(stack1.m_41720_() instanceof QuiverItem) || !stack1.m_41784_().m_128441_("invIndex") || stack1.m_41784_().m_128451_("invIndex") != index) continue;
                    contains = true;
                    break;
                }
            }
        }
        result.m_41764_(count);
        return result;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.m_204117_(TagInit.QUIVER_ITEMS);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        ItemStack oldStack = (ItemStack)this.stacks.get(slot);
        this.stacks.set(slot, (Object)stack);
    }

    public void adjustSize(int rows, int columns) {
        if (this.rows == rows && this.columns == columns) {
            return;
        }
        this.rows = rows;
        this.columns = columns;
        while (this.stacks.size() < this.rows * this.columns) {
            this.stacks.add((Object)ItemStack.f_41583_);
        }
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("rows", this.rows);
        compound.m_128405_("columns", this.columns);
        compound.m_128405_("stacks", this.stacks.size());
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            compound.m_128365_("stack" + slot, (Tag)((ItemStack)this.stacks.get(slot)).m_41739_(new CompoundTag()));
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        if (compound == null) {
            return;
        }
        this.rows = compound.m_128441_("rows") ? compound.m_128451_("rows") : compound.m_128451_("slots") / 9;
        this.columns = compound.m_128441_("columns") ? compound.m_128451_("columns") : compound.m_128451_("slots") / 9;
        this.stacks.clear();
        int size = compound.m_128441_("stacks") ? compound.m_128451_("stacks") : this.rows * this.columns;
        for (int slot = 0; slot < size; ++slot) {
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)compound.m_128469_("stack" + slot)));
        }
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
    }
}

