/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver.items;

import com.nyfaria.nyfsquiver.init.ContainerInit;
import com.nyfaria.nyfsquiver.items.QuiverInventory;
import com.nyfaria.nyfsquiver.items.QuiverItem;
import com.nyfaria.nyfsquiver.util.Dimension;
import com.nyfaria.nyfsquiver.util.Point;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class QuiverContainer
extends AbstractContainerMenu {
    public final int rows;
    public final int columns;
    public final int bagSlot;
    private final int padding = 8;
    private final int titleSpace = 10;

    public QuiverContainer(int id, Inventory player, int bagSlot, QuiverInventory quiverInventory, int rows, int columns) {
        super((MenuType)ContainerInit.QUIVER_CONTAINER.get(), id);
        this.bagSlot = bagSlot;
        this.rows = rows;
        this.columns = columns;
        this.addSlots(this.rows, this.columns, (IItemHandler)quiverInventory, player);
    }

    public Dimension getDimension() {
        return new Dimension(16 + Math.max(this.columns, 9) * 18, 44 + (this.rows + 4) * 18);
    }

    public Point getQuiverSlotPosition(Dimension dimension, int x, int y) {
        return new Point(dimension.getWidth() / 2 - this.columns * 9 + x * 18, 18 + y * 18);
    }

    public Point getPlayerInvSlotPosition(Dimension dimension, int x, int y) {
        return new Point(dimension.getWidth() / 2 - 81 + x * 18, dimension.getHeight() - 8 - 72 - 3 + y * 18 + (y == 3 ? 4 : 0));
    }

    private void addSlots(int rows, int columns, IItemHandler inventory, Inventory player) {
        int index;
        int column;
        int row;
        Dimension dimension = this.getDimension();
        int startX = 8;
        int startY = rows < 9 ? 17 : 8;
        rows = Math.min(rows, 9);
        for (row = 0; row < rows; ++row) {
            for (column = 0; column < columns; ++column) {
                Point getQuiverSlotPosition = this.getQuiverSlotPosition(dimension, column, row);
                index = row * columns + column;
                this.m_38897_((Slot)new SlotItemHandler(inventory, index, getQuiverSlotPosition.x, getQuiverSlotPosition.y));
            }
        }
        startX = 8 + (columns - 9) * 9;
        startY += rows * 18 + (rows == 9 ? 4 : 13);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                Point playerInvSlotPosition = this.getPlayerInvSlotPosition(dimension, column, row);
                index = column + row * 9 + 9;
                if (index == this.bagSlot) {
                    this.m_38897_(new Slot((Container)player, index, playerInvSlotPosition.x, playerInvSlotPosition.y){

                        public boolean canTakeStack(Player playerIn) {
                            return false;
                        }
                    });
                    continue;
                }
                this.m_38897_(new Slot((Container)player, index, playerInvSlotPosition.x, playerInvSlotPosition.y));
            }
        }
        startY += 58;
        for (int column2 = 0; column2 < 9; ++column2) {
            Point playerInvSlotPosition = this.getPlayerInvSlotPosition(dimension, column2, 3);
            if (column2 == this.bagSlot) {
                this.m_38897_(new Slot((Container)player, column2, playerInvSlotPosition.x, playerInvSlotPosition.y){

                    public boolean canTakeStack(Player playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)player, column2, playerInvSlotPosition.x, playerInvSlotPosition.y));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (index < this.rows * this.columns ? !this.m_38903_(slotStack, this.rows * 9, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.rows * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return returnStack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack stack;
        Slot slot;
        if (clickTypeIn == ClickType.SWAP && dragType == this.bagSlot) {
            return;
        }
        if (clickTypeIn == ClickType.PICKUP && dragType == 1 && slotId >= 0 && (slot = this.m_38853_(slotId)).m_8010_(player) && (stack = slot.m_7993_()).m_41720_() instanceof QuiverItem) {
            if (!player.f_19853_.f_46443_) {
                int n = slotId >= (this.rows + 3) * 9 ? slotId - (this.rows + 3) * 9 : (slotId >= this.rows * 9 ? slotId - (this.rows - 1) * 9 : -1);
            }
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }
}

