/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.nyfaria.nyfsquiver.NyfsQuiver;
import com.nyfaria.nyfsquiver.core.interfaces.QuiverContainerScreen;
import com.nyfaria.nyfsquiver.core.interfaces.QuiverRenameScreen;
import com.nyfaria.nyfsquiver.curios.QuiverRenderer;
import com.nyfaria.nyfsquiver.init.ContainerInit;
import com.nyfaria.nyfsquiver.init.ItemInit;
import com.nyfaria.nyfsquiver.items.QuiverModels;
import com.nyfaria.nyfsquiver.packets.PacketNextSlot;
import com.nyfaria.nyfsquiver.packets.PacketOpenQuiver;
import com.nyfaria.nyfsquiver.packets.PacketPreviousSlot;
import com.nyfaria.nyfsquiver.tooltip.ClientQuiverTooltip;
import com.nyfaria.nyfsquiver.tooltip.QuiverTooltip;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="nyfsquiver", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    private static KeyMapping NEXT_SLOT_KEY;
    private static KeyMapping PREVIOUS_SLOT_KEY;
    private static KeyMapping OPEN_QUIVER;

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent e) {
        MenuScreens.m_96206_((MenuType)((MenuType)ContainerInit.QUIVER_CONTAINER.get()), QuiverContainerScreen::new);
        NEXT_SLOT_KEY = new KeyMapping("keys.nyfsquiver.nextslot", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 93, "keys.category.nyfsquiver");
        PREVIOUS_SLOT_KEY = new KeyMapping("keys.nyfsquiver.previousslot", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 91, "keys.category.nyfsquiver");
        OPEN_QUIVER = new KeyMapping("keys.nyfsquiver.openquiver", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 66, "keys.category.nyfsquiver");
        ClientRegistry.registerKeyBinding((KeyMapping)NEXT_SLOT_KEY);
        ClientRegistry.registerKeyBinding((KeyMapping)PREVIOUS_SLOT_KEY);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_QUIVER);
        MinecraftForge.EVENT_BUS.addListener(ClientModEvents::onKey);
        MinecraftForgeClient.registerTooltipComponentFactory(QuiverTooltip.class, ClientQuiverTooltip::new);
        CuriosRendererRegistry.register((Item)((Item)ItemInit.BASIC_QUIVER.get()), QuiverRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemInit.IRON_QUIVER.get()), QuiverRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemInit.COPPER_QUIVER.get()), QuiverRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemInit.GOLD_QUIVER.get()), QuiverRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemInit.DIAMOND_QUIVER.get()), QuiverRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemInit.NETHERITE_QUIVER.get()), QuiverRenderer::new);
    }

    public static void openScreen(String defaultName, String name) {
        Minecraft.m_91087_().m_91152_((Screen)new QuiverRenameScreen(defaultName, name));
    }

    public static void onKey(InputEvent.KeyInputEvent e) {
        if (NEXT_SLOT_KEY != null && NEXT_SLOT_KEY.m_90832_(e.getKey(), e.getScanCode()) && Minecraft.m_91087_().f_91073_ != null && e.getAction() == 1 && NEXT_SLOT_KEY.isConflictContextAndModifierActive()) {
            NyfsQuiver.CHANNEL.sendToServer((Object)new PacketNextSlot(1));
        }
        if (PREVIOUS_SLOT_KEY != null && PREVIOUS_SLOT_KEY.m_90832_(e.getKey(), e.getScanCode()) && Minecraft.m_91087_().f_91073_ != null && e.getAction() == 1 && PREVIOUS_SLOT_KEY.isConflictContextAndModifierActive()) {
            NyfsQuiver.CHANNEL.sendToServer((Object)new PacketPreviousSlot(-1));
        }
        if (OPEN_QUIVER != null && OPEN_QUIVER.m_90832_(e.getKey(), e.getScanCode()) && Minecraft.m_91087_().f_91073_ != null && e.getAction() == 1 && OPEN_QUIVER.isConflictContextAndModifierActive()) {
            NyfsQuiver.CHANNEL.sendToServer((Object)new PacketOpenQuiver());
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.BASIC_QUIVER);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.IRON_QUIVER);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.COPPER_QUIVER);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.GOLD_QUIVER);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.DIAMOND_QUIVER);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.NETHERITE_QUIVER);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.BASIC_QUIVER_NOARROWS);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.IRON_QUIVER_NOARROWS);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.COPPER_QUIVER_NOARROWS);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.GOLD_QUIVER_NOARROWS);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.DIAMOND_QUIVER_NOARROWS);
        ForgeModelBakery.addSpecialModel((ResourceLocation)QuiverModels.NETHERITE_QUIVER_NOARROWS);
    }

    @SubscribeEvent
    public static void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            evt.addSprite(new ResourceLocation("nyfsquiver", "gui/basic_quiver"));
            evt.addSprite(new ResourceLocation("nyfsquiver", "gui/equipmentslot"));
        }
    }
}

