/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver.core.interfaces;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.nyfaria.nyfsquiver.items.QuiverContainer;
import com.nyfaria.nyfsquiver.util.Dimension;
import com.nyfaria.nyfsquiver.util.Rectangle;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class QuiverContainerScreen
extends AbstractContainerScreen<QuiverContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("nyfsquiver", "textures/gui/backpack_container.png");

    public QuiverContainerScreen(QuiverContainer handler, Inventory player, Component title) {
        super((AbstractContainerMenu)handler, player, title);
        Dimension dimension = handler.getDimension();
        this.f_97726_ = dimension.getWidth();
        this.f_97727_ = dimension.getHeight();
        this.f_97729_ = 7;
        this.f_97730_ = handler.getPlayerInvSlotPosition((Dimension)dimension, (int)0, (int)0).x;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private static void blitdQuad(Matrix4f matrices, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrices, (float)x0, (float)y1, (float)z).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_85982_(matrices, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_85982_(matrices, (float)x1, (float)y0, (float)z).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_85982_(matrices, (float)x0, (float)y0, (float)z).m_7421_(u0, v0).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderBackgroundTexture(matrices, new Rectangle(x, y, this.f_97726_, this.f_97727_), delta, -1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("textures/gui/container/hopper.png"));
        for (Slot slot : ((QuiverContainer)this.m_6262_()).f_38839_) {
            this.m_93228_(matrices, x + slot.f_40220_ - 1, y + slot.f_40221_ - 1, 43, 19, 18, 18);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    public void renderBackgroundTexture(PoseStack matrices, Rectangle bounds, float delta, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69424_((float)red, (float)green, (float)blue, (float)alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        int xTextureOffset = 0;
        int yTextureOffset = 66;
        this.m_93228_(matrices, x, y, 106 + xTextureOffset, 124 + yTextureOffset, 8, 8);
        this.m_93228_(matrices, x + width - 8, y, 248 + xTextureOffset, 124 + yTextureOffset, 8, 8);
        this.m_93228_(matrices, x, y + height - 8, 106 + xTextureOffset, 182 + yTextureOffset, 8, 8);
        this.m_93228_(matrices, x + width - 8, y + height - 8, 248 + xTextureOffset, 182 + yTextureOffset, 8, 8);
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        QuiverContainerScreen.blitdQuad(matrix, x + 8, x + width - 8, y, y + 8, this.m_93252_(), (float)(114 + xTextureOffset) / 256.0f, (float)(248 + xTextureOffset) / 256.0f, (float)(124 + yTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f);
        QuiverContainerScreen.blitdQuad(matrix, x + 8, x + width - 8, y + height - 8, y + height, this.m_93252_(), (float)(114 + xTextureOffset) / 256.0f, (float)(248 + xTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f, (float)(190 + yTextureOffset) / 256.0f);
        QuiverContainerScreen.blitdQuad(matrix, x, x + 8, y + 8, y + height - 8, this.m_93252_(), (float)(106 + xTextureOffset) / 256.0f, (float)(114 + xTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f);
        QuiverContainerScreen.blitdQuad(matrix, x + width - 8, x + width, y + 8, y + height - 8, this.m_93252_(), (float)(248 + xTextureOffset) / 256.0f, (float)(256 + xTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f);
        QuiverContainerScreen.blitdQuad(matrix, x + 8, x + width - 8, y + 8, y + height - 8, this.m_93252_(), (float)(114 + xTextureOffset) / 256.0f, (float)(248 + xTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f);
    }
}

