/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsquiver;

import com.google.common.collect.Lists;
import com.nyfaria.nyfsquiver.config.NQConfig;
import com.nyfaria.nyfsquiver.config.NQConfig_Client;
import com.nyfaria.nyfsquiver.init.ContainerInit;
import com.nyfaria.nyfsquiver.init.EnchantmentInit;
import com.nyfaria.nyfsquiver.init.ItemInit;
import com.nyfaria.nyfsquiver.init.RecipeInit;
import com.nyfaria.nyfsquiver.init.TagInit;
import com.nyfaria.nyfsquiver.items.QuiverItem;
import com.nyfaria.nyfsquiver.items.QuiverModels;
import com.nyfaria.nyfsquiver.items.QuiverStorageManager;
import com.nyfaria.nyfsquiver.packets.PacketMaxLayers;
import com.nyfaria.nyfsquiver.packets.PacketNextSlot;
import com.nyfaria.nyfsquiver.packets.PacketOpenQuiver;
import com.nyfaria.nyfsquiver.packets.PacketPreviousSlot;
import com.nyfaria.nyfsquiver.packets.PacketRename;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

@Mod(value="nyfsquiver")
public class NyfsQuiver {
    public static final String MODID = "nyfsquiver";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("nyfsquiver", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final ResourceLocation WIDGETS = new ResourceLocation("nyfsquiver", "textures/gui/widgets.png");
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("nyfsquiver"){

        @NotNull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemInit.BASIC_QUIVER.get());
        }
    };
    public static boolean drawn = false;
    public static TagKey<Item> QUIVER_CURIO = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "quiver"));
    public static final Predicate<ItemStack> QUIVER_PREDICATE = stack -> stack.m_204117_(QUIVER_CURIO);
    public static float interpolation = 0.0f;
    @Nullable
    public static ItemStack lastHeld = null;
    @Nullable
    public static List<ItemStack> lastReadyArrows = null;

    public NyfsQuiver() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NQConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)NQConfig_Client.CLIENT_SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemInit.ITEMS.register(bus);
        ContainerInit.CONTAINERS.register(bus);
        RecipeInit.RECIPES.register(bus);
        EnchantmentInit.ENCHANTMENTS.register(bus);
        QuiverModels.init();
        MinecraftForge.EVENT_BUS.register(QuiverStorageManager.class);
        CHANNEL.registerMessage(0, PacketRename.class, PacketRename::encode, PacketRename::decode, PacketRename::handle);
        CHANNEL.registerMessage(1, PacketMaxLayers.class, PacketMaxLayers::encode, PacketMaxLayers::decode, PacketMaxLayers::handle);
        CHANNEL.registerMessage(2, PacketNextSlot.class, (msg, buffer) -> {}, buffer -> new PacketNextSlot(0), PacketNextSlot::handle);
        CHANNEL.registerMessage(3, PacketPreviousSlot.class, (msg, buffer) -> {}, buffer -> new PacketPreviousSlot(0), PacketPreviousSlot::handle);
        CHANNEL.registerMessage(4, PacketOpenQuiver.class, (msg, buffer) -> {}, buffer -> new PacketOpenQuiver(), PacketOpenQuiver::handle);
        TagInit.init();
    }

    public static List<ItemStack> findAmmos(Player player, ItemStack shootable) {
        ItemStack quiverStack = CuriosApi.getCuriosHelper().findEquippedCurio(item -> item.m_41720_() instanceof QuiverItem, (LivingEntity)player).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.f_41583_);
        ItemStack itemstack = QuiverStorageManager.getCurrentSlotStack(quiverStack);
        if (quiverStack.m_41619_()) {
            return Lists.newLinkedList();
        }
        LinkedList list = Lists.newLinkedList();
        Predicate predicate = ((ProjectileWeaponItem)shootable.m_41720_()).m_6442_();
        if (!itemstack.m_41619_()) {
            list.add(itemstack);
        }
        if (list.isEmpty() && player.m_150110_().f_35937_) {
            list.add(new ItemStack((ItemLike)Items.f_42412_));
        }
        return list;
    }

    public static float bezier(float x, float min, float max) {
        return Mth.m_14036_((float)(x * x * (3.0f - 2.0f * x) / (1.0f / (max - min)) + min), (float)min, (float)max);
    }
}

