/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.explosions;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import me.jellysquid.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin {
    @Shadow
    @Final
    private float f_46017_;
    @Shadow
    @Final
    private double f_46013_;
    @Shadow
    @Final
    private double f_46014_;
    @Shadow
    @Final
    private double f_46015_;
    @Shadow
    @Final
    private Level f_46012_;
    @Shadow
    @Final
    private ExplosionDamageCalculator f_46019_;
    @Shadow
    @Final
    private boolean f_46009_;
    private final BlockPos.MutableBlockPos cachedPos = new BlockPos.MutableBlockPos();
    private final HashMap<BlockPos, Tuple<Float, BlockState>> blockAndBlastResCache = new HashMap();
    private int prevChunkX = Integer.MIN_VALUE;
    private int prevChunkZ = Integer.MIN_VALUE;
    private ChunkAccess prevChunk;
    private boolean explodeAirBlocks;
    private int minY;
    private int maxY;

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;Lnet/minecraft/world/explosion/ExplosionBehavior;DDDFZLnet/minecraft/world/explosion/Explosion$DestructionType;)V"}, at={@At(value="TAIL")})
    private void init(Level world, Entity entity, DamageSource damageSource, ExplosionDamageCalculator explosionBehavior, double d, double e, double f, float g, boolean bl, Explosion.BlockInteraction destructionType, CallbackInfo ci) {
        this.minY = this.f_46012_.m_141937_();
        this.maxY = this.f_46012_.m_151558_();
        boolean explodeAir = this.f_46009_;
        if (!explodeAir && this.f_46012_ != null && this.f_46012_.m_6042_().m_63965_()) {
            float overestimatedExplosionRange = 8 + (int)(6.0f * this.f_46017_);
            boolean endPortalX = false;
            boolean endPortalZ = false;
            if ((double)overestimatedExplosionRange > Math.abs(this.f_46013_ - (double)endPortalX) && (double)overestimatedExplosionRange > Math.abs(this.f_46015_ - (double)endPortalZ)) {
                explodeAir = true;
            }
        }
        this.explodeAirBlocks = explodeAir;
    }

    @Redirect(method={"collectBlocksAndDamageEntities()V"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Sets;newHashSet()Ljava/util/HashSet;", remap=false))
    public HashSet<BlockPos> skipNewHashSet() {
        return null;
    }

    @ModifyConstant(method={"collectBlocksAndDamageEntities()V"}, constant={@Constant(intValue=16, ordinal=1)})
    public int skipLoop(int prevValue) {
        return 0;
    }

    @Redirect(method={"collectBlocksAndDamageEntities()V"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z"))
    public boolean collectBlocks(List<BlockPos> affectedBlocks, Collection<BlockPos> collection) {
        LongOpenHashSet touched = new LongOpenHashSet(0);
        Random random = this.f_46012_.f_46441_;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        LongIterator it = touched.iterator();
        boolean added = false;
        while (it.hasNext()) {
            added |= affectedBlocks.add(BlockPos.m_122022_((long)it.nextLong()));
        }
        return added;
    }

    private void performRayCast(Random random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist * 0.3;
        double normY = vecY / dist * 0.3;
        double normZ = vecZ / dist * 0.3;
        float strength = this.f_46017_ * (0.7f + random.nextFloat() * 0.6f);
        double stepX = this.f_46013_;
        double stepY = this.f_46014_;
        double stepZ = this.f_46015_;
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        int boundMinY = this.minY;
        int boundMaxY = this.maxY;
        while (strength > 0.0f) {
            float resistance;
            int blockX = Mth.m_14107_((double)stepX);
            int blockY = Mth.m_14107_((double)stepY);
            int blockZ = Mth.m_14107_((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                if (blockY < boundMinY || blockY >= boundMaxY || blockX < -30000000 || blockZ < -30000000 || blockX >= 30000000 || blockZ >= 30000000) {
                    return;
                }
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance;
            strength -= 0.22500001f;
            stepX += normX;
            stepY += normY;
            stepZ += normZ;
        }
    }

    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        float reducedStrength;
        BlockPos.MutableBlockPos pos = this.cachedPos.m_122178_(blockX, blockY, blockZ);
        Tuple<Float, BlockState> blockAndBlastRes = this.blockAndBlastResCache.get(pos);
        if (blockAndBlastRes == null) {
            blockAndBlastRes = this.getBlockAndBlastRes(blockX, blockY, blockZ);
            this.blockAndBlastResCache.put((BlockPos)pos, blockAndBlastRes);
        }
        if (blockAndBlastRes.m_14419_() != null && (reducedStrength = strength - ((Float)blockAndBlastRes.m_14418_()).floatValue()) > 0.0f && (this.explodeAirBlocks || !((BlockState)blockAndBlastRes.m_14419_()).m_60795_()) && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, (BlockPos)pos, (BlockState)blockAndBlastRes.m_14419_(), reducedStrength)) {
            touched.add(pos.m_121878_());
        }
        return ((Float)blockAndBlastRes.m_14418_()).floatValue();
    }

    private Tuple<Float, BlockState> getBlockAndBlastRes(int blockX, int blockY, int blockZ) {
        Optional blastResistance;
        LevelChunkSection section;
        Tuple result = new Tuple((Object)0.0, null);
        BlockPos.MutableBlockPos pos = this.cachedPos.m_122178_(blockX, blockY, blockZ);
        if (this.f_46012_.m_151562_(blockY)) {
            Optional blastResistance2 = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, (BlockPos)pos, Blocks.f_50016_.m_49966_(), Fluids.f_76191_.m_76145_());
            if (blastResistance2.isPresent()) {
                result.m_145023_((Object)Float.valueOf((((Float)blastResistance2.get()).floatValue() + 0.3f) * 0.3f));
                return result;
            }
            return result;
        }
        int chunkX = Pos.ChunkCoord.fromBlockCoord(blockX);
        int chunkZ = Pos.ChunkCoord.fromBlockCoord(blockZ);
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.f_46012_.m_6325_(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        ChunkAccess chunk = this.prevChunk;
        BlockState blockState = Blocks.f_50016_.m_49966_();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.m_7103_()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)chunk, blockY)]) != null && !section.m_188008_() && (blockState = section.m_62982_(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).m_60734_() != Blocks.f_50016_) {
            FluidState fluidState = blockState.m_60819_();
            blastResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, (BlockPos)pos, blockState, fluidState);
        } else {
            blastResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, (BlockPos)pos, Blocks.f_50016_.m_49966_(), Fluids.f_76191_.m_76145_());
        }
        if (blastResistance.isPresent()) {
            totalResistance = (((Float)blastResistance.get()).floatValue() + 0.3f) * 0.3f;
        }
        result.m_145023_((Object)Float.valueOf(totalResistance));
        result.m_145025_((Object)blockState);
        return result;
    }
}

