/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.collisions.movement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.LithiumEntityCollisions;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public class EntityMixin {
    private static final List<VoxelShape> GET_ENTITIES_LATER = Collections.unmodifiableList(new ArrayList());

    @Redirect(method={"adjustMovementForCollisions(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getEntityCollisions(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;)Ljava/util/List;"))
    private List<VoxelShape> getEntitiesLater(Level world, Entity entity, AABB box) {
        return GET_ENTITIES_LATER;
    }

    @Overwrite
    public static Vec3 m_198894_(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions) {
        return EntityMixin.lithiumCollideMultiAxisMovement(entity, movement, entityBoundingBox, world, collisions == GET_ENTITIES_LATER);
    }

    private static Vec3 lithiumCollideMultiAxisMovement(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, boolean getEntityCollisions) {
        boolean velXSmallerVelZ;
        boolean isVerticalOnly;
        double velX = movement.f_82479_;
        double velY = movement.f_82480_;
        double velZ = movement.f_82481_;
        boolean bl = isVerticalOnly = velX == 0.0 && velZ == 0.0;
        AABB movementSpace = isVerticalOnly ? (velY < 0.0 ? new AABB(entityBoundingBox.f_82288_, entityBoundingBox.f_82289_ + velY, entityBoundingBox.f_82290_, entityBoundingBox.f_82291_, entityBoundingBox.f_82289_, entityBoundingBox.f_82293_) : new AABB(entityBoundingBox.f_82288_, entityBoundingBox.f_82292_, entityBoundingBox.f_82290_, entityBoundingBox.f_82291_, entityBoundingBox.f_82292_ + velY, entityBoundingBox.f_82293_)) : entityBoundingBox.m_82369_(movement);
        List<VoxelShape> blockCollisions = LithiumEntityCollisions.getBlockCollisions((CollisionGetter)world, entity, movementSpace);
        List<VoxelShape> entityWorldBorderCollisions = null;
        if (velY != 0.0 && (velY = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, blockCollisions, (double)velY)) != 0.0) {
            if (getEntityCollisions) {
                entityWorldBorderCollisions = LithiumEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
                velY = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velY);
            }
            if (velY != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82386_(0.0, velY, 0.0);
            }
        }
        boolean bl2 = velXSmallerVelZ = Math.abs(velX) < Math.abs(velZ);
        if (velXSmallerVelZ && (velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, blockCollisions, (double)velZ)) != 0.0) {
            if (entityWorldBorderCollisions == null && getEntityCollisions) {
                entityWorldBorderCollisions = LithiumEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
            }
            if (getEntityCollisions) {
                velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velZ);
            }
            if (velZ != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82386_(0.0, 0.0, velZ);
            }
        }
        if (velX != 0.0 && (velX = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, blockCollisions, (double)velX)) != 0.0) {
            if (entityWorldBorderCollisions == null && getEntityCollisions) {
                entityWorldBorderCollisions = LithiumEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
            }
            if (getEntityCollisions) {
                velX = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velX);
            }
            if (velX != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82386_(velX, 0.0, 0.0);
            }
        }
        if (!velXSmallerVelZ && velZ != 0.0 && (velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, blockCollisions, (double)velZ)) != 0.0 && getEntityCollisions) {
            if (entityWorldBorderCollisions == null) {
                entityWorldBorderCollisions = LithiumEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
            }
            velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velZ);
        }
        return new Vec3(velX, velY, velZ);
    }
}

