/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.cached_blockpos_iteration;

import it.unimi.dsi.fastutil.longs.LongList;
import me.jellysquid.mods.lithium.common.cached_blockpos_iteration.IterateOutwardsCache;
import me.jellysquid.mods.lithium.common.cached_blockpos_iteration.LongList2BlockPosMutableIterable;
import net.minecraft.core.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockPos.class})
public class BlockPosMixin {
    private static final IterateOutwardsCache ITERATE_OUTWARDS_CACHE = new IterateOutwardsCache(50);
    private static final LongList HOGLIN_PIGLIN_CACHE = ITERATE_OUTWARDS_CACHE.getOrCompute(8, 4, 8);

    @Inject(method={"iterateOutwards"}, at={@At(value="HEAD")}, cancellable=true)
    private static void iterateOutwards(BlockPos center, int xRange, int yRange, int zRange, CallbackInfoReturnable<Iterable<BlockPos>> cir) {
        if (center == IterateOutwardsCache.POS_ZERO) {
            return;
        }
        LongList positions = xRange == 8 && yRange == 4 && zRange == 8 ? HOGLIN_PIGLIN_CACHE : ITERATE_OUTWARDS_CACHE.getOrCompute(xRange, yRange, zRange);
        cir.setReturnValue((Object)new LongList2BlockPosMutableIterable(center, positions));
    }
}

