/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.hopper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import me.jellysquid.mods.lithium.api.inventory.LithiumInventory;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedInventoryEntityMovementTracker;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedItemEntityMovementTracker;
import me.jellysquid.mods.lithium.common.hopper.HopperHelper;
import me.jellysquid.mods.lithium.common.hopper.InventoryHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.common.hopper.UpdateReceiver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={HopperBlockEntity.class})
public abstract class HopperBlockEntityMixin
extends BlockEntity
implements Hopper,
UpdateReceiver,
LithiumInventory {
    private static final Container USE_ENTITY_INVENTORY = new SimpleContainer(0);
    @Shadow
    private long f_59303_;
    private long myLastInsertChangeCount;
    private long myLastExtractChangeCount;
    private long myLastCollectChangeCount;
    private Container insertBlockInventory;
    private Container extractBlockInventory;
    private LithiumInventory insertInventory;
    private LithiumInventory extractInventory;
    private int insertInventoryRemovedCount;
    private int extractInventoryRemovedCount;
    private LithiumStackList insertInventoryStackList;
    private LithiumStackList extractInventoryStackList;
    private long insertInventoryChangeCount;
    private long extractInventoryChangeCount;
    private SectionedItemEntityMovementTracker<ItemEntity> extractItemEntityTracker;
    private boolean extractItemEntityTrackerWasEmpty;
    private AABB[] extractItemEntityBoxes;
    private long extractItemEntityAttemptTime;
    private SectionedInventoryEntityMovementTracker<Container> extractInventoryEntityTracker;
    private AABB extractInventoryEntityBox;
    private long extractInventoryEntityAttemptTime;
    private SectionedInventoryEntityMovementTracker<Container> insertInventoryEntityTracker;
    private AABB insertInventoryEntityBox;
    private long insertInventoryEntityAttemptTime;

    public HopperBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Shadow
    @Nullable
    private static native Container m_155596_(Level var0, Hopper var1);

    @Shadow
    private static native boolean ejectItems(Level var0, BlockPos var1, BlockState var2, HopperBlockEntity var3);

    @Shadow
    protected abstract boolean m_59409_();

    @Shadow
    protected abstract void m_59395_(int var1);

    @Shadow
    private static native boolean m_59380_(Container var0, ItemStack var1, int var2, Direction var3);

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputInventory(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Lnet/minecraft/inventory/Inventory;"))
    private static Container getExtractInventory(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntityMixin.m_155596_(world, hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        Container blockInventory = hopperBlockEntity.getExtractBlockInventory(world);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (hopperBlockEntity.extractInventoryEntityTracker == null) {
            hopperBlockEntity.initExtractInventoryTracker(world);
        }
        if (hopperBlockEntity.extractInventoryEntityTracker.isUnchangedSince(hopperBlockEntity.extractInventoryEntityAttemptTime)) {
            return null;
        }
        hopperBlockEntity.extractInventoryEntityAttemptTime = Long.MIN_VALUE;
        hopperBlockEntity.myLastCollectChangeCount = InventoryHelper.getLithiumStackList(hopperBlockEntity).getModCount();
        List<Container> inventoryEntities = hopperBlockEntity.extractInventoryEntityTracker.getEntities(hopperBlockEntity.extractInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            hopperBlockEntity.extractInventoryEntityAttemptTime = hopperBlockEntity.f_59303_;
            return null;
        }
        Container inventory = inventoryEntities.get(world.f_46441_.nextInt(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != hopperBlockEntity.extractInventory || hopperBlockEntity.extractInventoryStackList != extractInventoryStackList) {
                hopperBlockEntity.extractInventory = optimizedInventory;
                hopperBlockEntity.extractInventoryStackList = extractInventoryStackList;
                hopperBlockEntity.extractInventoryChangeCount = hopperBlockEntity.extractInventoryStackList.getModCount() - 1L;
            }
        }
        return inventory;
    }

    @Inject(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/util/math/Direction;DOWN:Lnet/minecraft/util/math/Direction;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void lithiumExtract(Level world, Hopper to, CallbackInfoReturnable<Boolean> cir) {
        Container from = HopperBlockEntityMixin.m_155596_(world, to);
        if (!(to instanceof HopperBlockEntityMixin)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)to;
        if (from != hopperBlockEntity.extractInventory) {
            return;
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        LithiumStackList fromStackList = hopperBlockEntity.extractInventoryStackList;
        if (hopperStackList.getModCount() == hopperBlockEntity.myLastExtractChangeCount && fromStackList.getModCount() == hopperBlockEntity.extractInventoryChangeCount) {
            fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            cir.setReturnValue((Object)false);
            return;
        }
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).m_7071_(Direction.DOWN) : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            ItemStack itemStack = (ItemStack)fromStackList.get(fromSlot);
            if (itemStack.m_41619_() || !HopperBlockEntityMixin.m_59380_(from, itemStack, fromSlot, Direction.DOWN)) continue;
            ItemStack takenItem = from.m_7407_(fromSlot, 1);
            assert (!takenItem.m_41619_());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((Container)to, takenItem, null);
            if (transferSuccess) {
                to.m_6596_();
                from.m_6596_();
                cir.setReturnValue((Object)true);
                return;
            }
            ItemStack restoredStack = (ItemStack)fromStackList.get(fromSlot);
            if (restoredStack.m_41619_()) {
                restoredStack = takenItem;
            } else {
                restoredStack.m_41769_(1);
            }
            from.m_6836_(fromSlot, restoredStack);
        }
        hopperBlockEntity.myLastExtractChangeCount = hopperStackList.getModCount();
        if (fromStackList != null) {
            hopperBlockEntity.extractInventoryChangeCount = fromStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isFull()Z"))
    private static boolean lithiumHopperIsFull(HopperBlockEntity hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getFullSlots() == lithiumStackList.size();
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isEmpty()Z"))
    private static boolean lithiumHopperIsEmpty(HopperBlockEntity hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getOccupiedSlots() == 0;
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;ejectItems(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;)Z"))
    private static boolean lithiumInsert(Level world, BlockPos pos, BlockState hopperState, HopperBlockEntity blockEntity, Level world2, BlockPos pos2, BlockState state2, HopperBlockEntity blockentity2, BooleanSupplier booleanSupplier) {
        boolean insertInventoryWasEmptyHopperNotDisabled;
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)HopperBlockEntity.m_59390_((Level)world, (BlockPos)pos);
        Container insertInventory = hopperBlockEntity.getInsertInventory(world, hopperState);
        if (insertInventory == null) {
            return HopperBlockEntityMixin.ejectItems(world, pos, hopperState, blockEntity);
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        if (hopperBlockEntity.insertInventory == insertInventory && hopperStackList.getModCount() == hopperBlockEntity.myLastInsertChangeCount && hopperBlockEntity.insertInventoryStackList.getModCount() == hopperBlockEntity.insertInventoryChangeCount) {
            return false;
        }
        boolean bl = insertInventoryWasEmptyHopperNotDisabled = insertInventory instanceof HopperBlockEntityMixin && !((HopperBlockEntityMixin)insertInventory).m_59409_() && hopperBlockEntity.insertInventoryStackList.getOccupiedSlots() == 0;
        if (hopperBlockEntity.insertInventory != insertInventory || hopperBlockEntity.insertInventoryStackList.getFullSlots() != hopperBlockEntity.insertInventoryStackList.size()) {
            Direction fromDirection = ((Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
            int size = hopperStackList.size();
            for (int i = 0; i < size; ++i) {
                boolean transferSuccess;
                ItemStack transferStack = (ItemStack)hopperStackList.get(i);
                if (transferStack.m_41619_() || !(transferSuccess = HopperHelper.tryMoveSingleItem(insertInventory, transferStack, fromDirection))) continue;
                if (insertInventoryWasEmptyHopperNotDisabled) {
                    HopperBlockEntityMixin receivingHopper = (HopperBlockEntityMixin)insertInventory;
                    int k = 8;
                    if (receivingHopper.f_59303_ >= hopperBlockEntity.f_59303_) {
                        k = 7;
                    }
                    receivingHopper.m_59395_(k);
                }
                insertInventory.m_6596_();
                return true;
            }
        }
        hopperBlockEntity.myLastInsertChangeCount = hopperStackList.getModCount();
        if (hopperBlockEntity.insertInventoryStackList != null) {
            hopperBlockEntity.insertInventoryChangeCount = hopperBlockEntity.insertInventoryStackList.getModCount();
        }
        return false;
    }

    @Override
    public void onNeighborUpdate(boolean above) {
        if (above) {
            if (this.extractBlockInventory != null) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertBlockInventory != null) {
            this.invalidateBlockInsertionData();
        }
    }

    @Redirect(method={"ejectItems(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/inventory/Inventory;"))
    private static Container nullify(Level world, BlockPos pos, BlockState state) {
        return null;
    }

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputItemEntities(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Ljava/util/List;"))
    private static List<ItemEntity> lithiumGetInputItemEntities(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntity.m_155589_((Level)world, (Hopper)hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        if (hopperBlockEntity.extractItemEntityTracker == null) {
            hopperBlockEntity.initExtractItemEntityTracker();
        }
        long modCount = InventoryHelper.getLithiumStackList(hopperBlockEntity).getModCount();
        if ((hopperBlockEntity.extractItemEntityTrackerWasEmpty || hopperBlockEntity.myLastCollectChangeCount == modCount) && hopperBlockEntity.extractItemEntityTracker.isUnchangedSince(hopperBlockEntity.extractItemEntityAttemptTime)) {
            return Collections.emptyList();
        }
        hopperBlockEntity.myLastCollectChangeCount = modCount;
        List<ItemEntity> itemEntities = hopperBlockEntity.extractItemEntityTracker.getEntities(hopperBlockEntity.extractItemEntityBoxes);
        hopperBlockEntity.extractItemEntityAttemptTime = hopperBlockEntity.f_59303_;
        hopperBlockEntity.extractItemEntityTrackerWasEmpty = itemEntities.isEmpty();
        return itemEntities;
    }

    private void cacheInsertBlockInventory(Container insertInventory) {
        assert (!(insertInventory instanceof Entity));
        if (insertInventory instanceof BlockEntity || insertInventory instanceof CompoundContainer) {
            this.insertBlockInventory = null;
        } else {
            Container container = this.insertBlockInventory = insertInventory == null ? USE_ENTITY_INVENTORY : insertInventory;
        }
        if (insertInventory instanceof LithiumInventory) {
            LithiumStackList insertInventoryStackList;
            LithiumInventory optimizedInventory;
            this.insertInventory = optimizedInventory = (LithiumInventory)insertInventory;
            this.insertInventoryStackList = insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            this.insertInventoryChangeCount = insertInventoryStackList.getModCount() - 1L;
            this.insertInventoryRemovedCount = optimizedInventory.getRemovedCountLithium();
        } else {
            this.insertInventory = null;
            this.insertInventoryStackList = null;
            this.insertInventoryChangeCount = 0L;
            this.insertInventoryRemovedCount = 0;
        }
    }

    public Container getInsertBlockInventory(Level world, BlockState hopperState) {
        LithiumStackList insertInventoryStackList;
        Container inventory = this.insertBlockInventory;
        if (inventory != null) {
            return inventory == USE_ENTITY_INVENTORY ? null : inventory;
        }
        LithiumInventory optimizedInventory = this.insertInventory;
        if (optimizedInventory != null && (insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory)) == this.insertInventoryStackList && optimizedInventory.getRemovedCountLithium() == this.insertInventoryRemovedCount) {
            return optimizedInventory;
        }
        Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
        inventory = HopperHelper.vanillaGetBlockInventory(world, this.m_58899_().m_142300_(direction));
        this.cacheInsertBlockInventory(inventory);
        return inventory;
    }

    @Overwrite
    private static boolean m_59397_(Container inv, Direction side) {
        int[] availableSlots = inv instanceof WorldlyContainer ? ((WorldlyContainer)inv).m_7071_(side) : null;
        int fromSize = availableSlots != null ? availableSlots.length : inv.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int slot;
            int n = slot = availableSlots != null ? availableSlots[i] : i;
            if (inv.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void cacheExtractBlockInventory(Container extractInventory) {
        assert (!(extractInventory instanceof Entity));
        if (extractInventory instanceof BlockEntity || extractInventory instanceof CompoundContainer) {
            this.extractBlockInventory = null;
        } else {
            Container container = this.extractBlockInventory = extractInventory == null ? USE_ENTITY_INVENTORY : extractInventory;
        }
        if (extractInventory instanceof LithiumInventory) {
            LithiumStackList extractInventoryStackList;
            LithiumInventory optimizedInventory;
            this.extractInventory = optimizedInventory = (LithiumInventory)extractInventory;
            this.extractInventoryStackList = extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            this.extractInventoryChangeCount = extractInventoryStackList.getModCount() - 1L;
            this.extractInventoryRemovedCount = optimizedInventory.getRemovedCountLithium();
        } else {
            this.extractInventory = null;
            this.extractInventoryStackList = null;
            this.extractInventoryChangeCount = 0L;
            this.extractInventoryRemovedCount = 0;
        }
    }

    public Container getExtractBlockInventory(Level world) {
        LithiumStackList extractInventoryStackList;
        Container inventory = this.extractBlockInventory;
        if (inventory != null) {
            return inventory == USE_ENTITY_INVENTORY ? null : inventory;
        }
        LithiumInventory optimizedInventory = this.extractInventory;
        if (optimizedInventory != null && (extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory)) == this.extractInventoryStackList && optimizedInventory.getRemovedCountLithium() == this.extractInventoryRemovedCount) {
            return optimizedInventory;
        }
        inventory = HopperHelper.vanillaGetBlockInventory(world, this.m_58899_().m_7494_());
        this.cacheExtractBlockInventory(inventory);
        return inventory;
    }

    public Container getInsertInventory(Level world, BlockState hopperState) {
        Container blockInventory = this.getInsertBlockInventory(world, hopperState);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (this.insertInventoryEntityTracker == null) {
            this.initInsertInventoryTracker(world, hopperState);
        }
        if (this.insertInventoryEntityTracker.isUnchangedSince(this.insertInventoryEntityAttemptTime)) {
            return null;
        }
        this.insertInventoryEntityAttemptTime = Long.MIN_VALUE;
        this.myLastCollectChangeCount = InventoryHelper.getLithiumStackList(this).getModCount();
        List<Container> inventoryEntities = this.insertInventoryEntityTracker.getEntities(this.insertInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.insertInventoryEntityAttemptTime = this.f_59303_;
            return null;
        }
        Container inventory = inventoryEntities.get(world.f_46441_.nextInt(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != this.insertInventory || this.insertInventoryStackList != insertInventoryStackList) {
                this.insertInventory = optimizedInventory;
                this.insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                this.insertInventoryChangeCount = this.insertInventoryStackList.getModCount() - 1L;
            }
        }
        return inventory;
    }

    private void initExtractItemEntityTracker() {
        assert (this.f_58857_ instanceof ServerLevel);
        ArrayList<AABB> list = new ArrayList<AABB>();
        AABB encompassingBox = null;
        for (AABB box : this.m_59300_().m_83299_()) {
            AABB offsetBox = box.m_82386_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
            list.add(offsetBox);
            if (encompassingBox == null) {
                encompassingBox = offsetBox;
                continue;
            }
            encompassingBox = encompassingBox.m_82367_(offsetBox);
        }
        list.add(encompassingBox);
        this.extractItemEntityBoxes = list.toArray(new AABB[0]);
        this.extractItemEntityTracker = SectionedItemEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, encompassingBox, ItemEntity.class);
        this.extractItemEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initExtractInventoryTracker(Level world) {
        assert (world instanceof ServerLevel);
        BlockPos pos = this.f_58858_.m_142300_(Direction.UP);
        this.extractInventoryEntityBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        this.extractInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, this.extractInventoryEntityBox, Container.class);
        this.extractInventoryEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initInsertInventoryTracker(Level world, BlockState hopperState) {
        assert (world instanceof ServerLevel);
        Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
        BlockPos pos = this.f_58858_.m_142300_(direction);
        this.insertInventoryEntityBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        this.insertInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, this.insertInventoryEntityBox, Container.class);
        this.insertInventoryEntityAttemptTime = Long.MIN_VALUE;
    }

    public void m_155250_(BlockState state) {
        BlockState cachedState = this.m_58900_();
        super.m_155250_(state);
        if (state.m_61143_((Property)HopperBlock.f_54021_) != cachedState.m_61143_((Property)HopperBlock.f_54021_)) {
            this.invalidateCachedData();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateCachedData();
    }

    private void invalidateCachedData() {
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    private void invalidateInsertionData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.insertInventoryEntityTracker != null) {
                this.insertInventoryEntityTracker.unRegister(serverWorld);
                this.insertInventoryEntityTracker = null;
                this.insertInventoryEntityBox = null;
            }
        }
        this.invalidateBlockInsertionData();
    }

    private void invalidateBlockInsertionData() {
        this.insertBlockInventory = null;
        this.insertInventory = null;
        this.insertInventoryRemovedCount = 0;
        this.insertInventoryStackList = null;
        this.insertInventoryChangeCount = 0L;
    }

    private void invalidateExtractionData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.extractInventoryEntityTracker != null) {
                this.extractInventoryEntityTracker.unRegister(serverWorld);
                this.extractInventoryEntityTracker = null;
                this.extractInventoryEntityBox = null;
            }
            if (this.extractItemEntityTracker != null) {
                this.extractItemEntityTracker.unRegister(serverWorld);
                this.extractItemEntityTracker = null;
                this.extractItemEntityBoxes = null;
                this.extractItemEntityTrackerWasEmpty = false;
            }
        }
        this.invalidateBlockExtractionData();
    }

    private void invalidateBlockExtractionData() {
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractInventoryRemovedCount = 0;
        this.extractInventoryStackList = null;
        this.extractInventoryChangeCount = 0L;
    }
}

