/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.poi;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.jellysquid.mods.lithium.common.util.Distances;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestStorageExtended;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import me.jellysquid.mods.lithium.common.world.interests.iterator.NearbyPointOfInterestStream;
import me.jellysquid.mods.lithium.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import me.jellysquid.mods.lithium.common.world.interests.types.PointOfInterestTypeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PoiManager.class})
public abstract class PointOfInterestStorageMixin
extends SectionStorage<PoiSection>
implements PointOfInterestStorageExtended {
    public PointOfInterestStorageMixin(Path path, Function<Runnable, Codec<PoiSection>> codecFactory, Function<Runnable, PoiSection> factory, DataFixer dataFixer, DataFixTypes dataFixTypes, boolean dsync, LevelHeightAccessor world) {
        super(path, codecFactory, factory, dataFixer, dataFixTypes, dsync, world);
    }

    @Overwrite
    public void m_27047_(ChunkPos chunkPos_1, LevelChunkSection section) {
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos_1, (int)(section.m_63017_() >> 4));
        PoiSection set = this.m_63823_(sectionPos.m_123252_()).orElse(null);
        if (set != null) {
            set.m_27302_(consumer -> {
                if (PointOfInterestTypeHelper.shouldScan(section)) {
                    this.m_27069_(section, sectionPos, (BiConsumer<BlockPos, PoiType>)consumer);
                }
            });
        } else if (PointOfInterestTypeHelper.shouldScan(section)) {
            set = (PoiSection)this.m_63827_(sectionPos.m_123252_());
            this.m_27069_(section, sectionPos, (arg_0, arg_1) -> ((PoiSection)set).m_27281_(arg_0, arg_1));
        }
    }

    @Overwrite
    @VisibleForDebug
    public Stream<PoiRecord> m_27117_(Predicate<PoiType> predicate, ChunkPos pos, PoiManager.Occupancy status) {
        return ((RegionBasedStorageSectionExtended)((Object)this)).getWithinChunkColumn(pos.f_45578_, pos.f_45579_).flatMap(set -> set.m_27304_(predicate, status));
    }

    @Overwrite
    public Optional<BlockPos> m_27126_(Predicate<PoiType> typePredicate, Predicate<BlockPos> posPredicate, PoiManager.Occupancy status, BlockPos pos, int radius, Random rand) {
        ArrayList<PoiRecord> list = this.withinSphereChunkSectionSorted(typePredicate, pos, radius, status);
        for (int i = list.size() - 1; i >= 0; --i) {
            PoiRecord currentPOI = list.set(rand.nextInt(i + 1), list.get(i));
            list.set(i, currentPOI);
            if (!posPredicate.test(currentPOI.m_27257_())) continue;
            return Optional.of(currentPOI.m_27257_());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<BlockPos> m_27192_(Predicate<PoiType> predicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        return this.m_148658_(predicate, null, pos, radius, status);
    }

    @Overwrite
    public Optional<BlockPos> m_148658_(Predicate<PoiType> predicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        Stream<PoiRecord> pointOfInterestStream = this.streamOutwards(pos, radius, status, true, false, predicate, posPredicate == null ? null : poi -> posPredicate.test(poi.m_27257_()));
        return pointOfInterestStream.map(PoiRecord::m_27257_).findFirst();
    }

    @Overwrite
    public long m_27121_(Predicate<PoiType> predicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        return this.withinSphereChunkSectionSorted(predicate, pos, radius, status).size();
    }

    @Overwrite
    public Stream<PoiRecord> m_27181_(Predicate<PoiType> predicate, BlockPos sphereOrigin, int radius, PoiManager.Occupancy status) {
        return this.withinSphereChunkSectionSortedStream(predicate, sphereOrigin, radius, status);
    }

    @Override
    public Optional<PoiRecord> findNearestForPortalLogic(BlockPos origin, int radius, PoiType type, PoiManager.Occupancy status, Predicate<PoiRecord> afterSortPredicate, WorldBorder worldBorder) {
        boolean worldBorderIsFarAway = worldBorder == null || worldBorder.m_61941_((double)origin.m_123341_(), (double)origin.m_123343_()) > (double)(radius + 3);
        Predicate<PoiRecord> poiPredicateAfterSorting = worldBorderIsFarAway ? afterSortPredicate : poi -> worldBorder.m_61937_(poi.m_27257_()) && afterSortPredicate.test((PoiRecord)poi);
        return this.streamOutwards(origin, radius, status, true, true, new SinglePointOfInterestTypeFilter(type), poiPredicateAfterSorting).findFirst();
    }

    private Stream<PoiRecord> withinSphereChunkSectionSortedStream(Predicate<PoiType> predicate, final BlockPos origin, int radius, PoiManager.Occupancy status) {
        final double radiusSq = radius * radius;
        final int minChunkX = origin.m_123341_() - radius - 1 >> 4;
        final int minChunkZ = origin.m_123343_() - radius - 1 >> 4;
        int maxChunkX = origin.m_123341_() + radius + 1 >> 4;
        final int maxChunkZ = origin.m_123343_() + radius + 1 >> 4;
        final RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        final int limit = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        Stream<Stream<PoiSection>> stream = StreamSupport.stream(new Spliterators.AbstractSpliterator<Stream<PoiSection>>((long)limit, 16){
            int chunkX;
            int chunkZ;
            int iterated;
            {
                super(est, additionalCharacteristics);
                this.chunkX = minChunkX;
                this.chunkZ = minChunkZ;
                this.iterated = 0;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Stream<PoiSection>> action) {
                do {
                    if (this.iterated >= limit) {
                        return false;
                    }
                    if (this.chunkZ > maxChunkZ) {
                        ++this.chunkX;
                        this.chunkZ = minChunkZ;
                    } else {
                        ++this.chunkZ;
                    }
                    ++this.iterated;
                } while (!(Distances.getMinChunkToBlockDistanceL2Sq(origin, this.chunkX, this.chunkZ) <= radiusSq));
                action.accept(storage.getWithinChunkColumn(this.chunkX, this.chunkZ));
                return true;
            }
        }, false);
        return stream.flatMap(setStream -> setStream.flatMap(set -> set.m_27304_(predicate, status).filter(point -> Distances.isWithinCircleRadius(origin, radiusSq, point.m_27257_()))));
    }

    private ArrayList<PoiRecord> withinSphereChunkSectionSorted(Predicate<PoiType> predicate, BlockPos origin, int radius, PoiManager.Occupancy status) {
        double radiusSq = radius * radius;
        int minChunkX = origin.m_123341_() - radius - 1 >> 4;
        int minChunkZ = origin.m_123343_() - radius - 1 >> 4;
        int maxChunkX = origin.m_123341_() + radius + 1 >> 4;
        int maxChunkZ = origin.m_123343_() + radius + 1 >> 4;
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        ArrayList<PoiRecord> points = new ArrayList<PoiRecord>();
        Consumer<PoiRecord> collector = point -> {
            if (Distances.isWithinCircleRadius(origin, radiusSq, point.m_27257_())) {
                points.add((PoiRecord)point);
            }
        };
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                for (PoiSection set : storage.getInChunkColumn(x, z)) {
                    ((PointOfInterestSetExtended)set).collectMatchingPoints(predicate, status, collector);
                }
            }
        }
        return points;
    }

    private Stream<PoiRecord> streamOutwards(BlockPos origin, int radius, PoiManager.Occupancy status, boolean useSquareDistanceLimit, boolean preferNegativeY, Predicate<PoiType> typePredicate, @Nullable Predicate<PoiRecord> afterSortingPredicate) {
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        return StreamSupport.stream(new NearbyPointOfInterestStream(typePredicate, status, useSquareDistanceLimit, preferNegativeY, afterSortingPredicate, origin, radius, storage), false);
    }

    @Shadow
    protected abstract void m_27069_(LevelChunkSection var1, SectionPos var2, BiConsumer<BlockPos, PoiType> var3);
}

