/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.pathing;

import me.jellysquid.mods.lithium.common.ai.pathing.PathNodeCache;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={WalkNodeEvaluator.class})
public abstract class LandPathNodeMakerMixin {
    @Overwrite
    public static BlockPathTypes m_77643_(BlockGetter blockView, BlockPos blockPos) {
        BlockState blockState = blockView.m_8055_(blockPos);
        BlockPathTypes type = PathNodeCache.getPathNodeType(blockState);
        if (type == BlockPathTypes.OPEN || type == BlockPathTypes.WATER) {
            if (!blockState.m_60647_(blockView, blockPos, PathComputationType.LAND)) {
                return BlockPathTypes.BLOCKED;
            }
            return type;
        }
        return type;
    }

    @Overwrite
    public static BlockPathTypes m_77607_(BlockGetter world, BlockPos.MutableBlockPos pos, BlockPathTypes type) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        LevelChunkSection section = null;
        if (world instanceof CollisionGetter && WorldHelper.areNeighborsWithinSameChunk((BlockPos)pos)) {
            ChunkAccess chunk;
            if (!world.m_151562_(y) && (chunk = (ChunkAccess)((CollisionGetter)world).m_7925_(Pos.ChunkCoord.fromBlockCoord(x), Pos.ChunkCoord.fromBlockCoord(z))) != null) {
                section = chunk.m_7103_()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)world, y)];
            }
            if (section == null || PathNodeCache.isSectionSafeAsNeighbor(section)) {
                return type;
            }
        }
        int xStart = x - 1;
        int yStart = y - 1;
        int zStart = z - 1;
        int xEnd = x + 1;
        int yEnd = y + 1;
        int zEnd = z + 1;
        for (int adjX = xStart; adjX <= xEnd; ++adjX) {
            for (int adjY = yStart; adjY <= yEnd; ++adjY) {
                for (int adjZ = zStart; adjZ <= zEnd; ++adjZ) {
                    BlockPathTypes neighborType;
                    BlockState state;
                    if (adjX == x && adjZ == z || (state = section != null ? section.m_62982_(adjX & 0xF, adjY & 0xF, adjZ & 0xF) : world.m_8055_((BlockPos)pos.m_122178_(adjX, adjY, adjZ))).m_60795_() || (neighborType = PathNodeCache.getNeighborPathNodeType((BlockBehaviour.BlockStateBase)state)) == BlockPathTypes.OPEN) continue;
                    return neighborType;
                }
            }
        }
        return type;
    }
}

