/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.math;

public class MathUtils {
    private static final float[] SIN_TABLE_FAST = new float[4096];
    private static final float radToIndex = MathUtils.roundToFloat(651.8986469044033);

    public static float sin(float value) {
        return SIN_TABLE_FAST[(int)(value * radToIndex) & 0xFFF];
    }

    public static float cos(float value) {
        return SIN_TABLE_FAST[(int)(value * radToIndex + 1024.0f) & 0xFFF];
    }

    public static float roundToFloat(double d) {
        return (float)((double)Math.round(d * 1.0E8) / 1.0E8);
    }

    static {
        for (int j = 0; j < SIN_TABLE_FAST.length; ++j) {
            MathUtils.SIN_TABLE_FAST[j] = MathUtils.roundToFloat(Math.sin((double)j * Math.PI * 2.0 / 4096.0));
        }
    }
}

