/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.hopper;

import me.jellysquid.mods.lithium.common.hopper.ComparatorUpdatePattern;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HopperHelper {
    @Nullable
    public static Container vanillaGetBlockInventory(Level world, BlockPos blockPos) {
        BlockEntity blockEntity;
        WorldlyContainer inventory = null;
        BlockState blockState = world.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            inventory = ((WorldlyContainerHolder)block).m_5840_(blockState, (LevelAccessor)world, blockPos);
        } else if (blockState.m_155947_() && (blockEntity = world.m_7702_(blockPos)) instanceof Container && (inventory = (Container)blockEntity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            inventory = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockState, (Level)world, (BlockPos)blockPos, (boolean)true);
        }
        return inventory;
    }

    public static boolean tryMoveSingleItem(Container to, ItemStack stack, @Nullable Direction fromDirection) {
        WorldlyContainer toSided;
        WorldlyContainer worldlyContainer = toSided = to instanceof WorldlyContainer ? (WorldlyContainer)to : null;
        if (toSided != null && fromDirection != null) {
            int[] slots = toSided.m_7071_(fromDirection);
            for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, slots[slotIndex], fromDirection)) continue;
                return true;
            }
        } else {
            int j = to.m_6643_();
            for (int slot = 0; slot < j; ++slot) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, slot, fromDirection)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryMoveSingleItem(Container to, @Nullable WorldlyContainer toSided, ItemStack transferStack, int targetSlot, @Nullable Direction fromDirection) {
        ItemStack toStack = to.m_8020_(targetSlot);
        if (to.m_7013_(targetSlot, transferStack) && (toSided == null || toSided.m_7155_(targetSlot, transferStack, fromDirection))) {
            if (toStack.m_41619_()) {
                ItemStack singleItem = transferStack.m_41620_(1);
                to.m_6836_(targetSlot, singleItem);
                return true;
            }
            if (toStack.m_150930_(transferStack.m_41720_())) {
                int toCount = toStack.m_41613_();
                if (toStack.m_41741_() > toCount && to.m_6893_() > toCount && ItemStack.m_41658_((ItemStack)toStack, (ItemStack)transferStack)) {
                    transferStack.m_41774_(1);
                    toStack.m_41769_(1);
                    return true;
                }
            }
        }
        return false;
    }

    public static ComparatorUpdatePattern determineComparatorUpdatePattern(Container from, LithiumStackList fromStackList) {
        if (from instanceof HopperBlockEntity || !(from instanceof RandomizableContainerBlockEntity)) {
            return ComparatorUpdatePattern.NO_UPDATE;
        }
        float contentWeight = 0.0f;
        int numOccupiedSlots = 0;
        for (int j = 0; j < from.m_6643_(); ++j) {
            ItemStack itemStack = from.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            int maxStackSize = Math.min(from.m_6893_(), itemStack.m_41741_());
            contentWeight += (float)itemStack.m_41613_() / (float)maxStackSize;
            ++numOccupiedSlots;
        }
        float f = contentWeight;
        int originalSignalStrength = Mth.m_14143_((float)((f /= (float)from.m_6643_()) * 14.0f)) + (numOccupiedSlots > 0 ? 1 : 0);
        ComparatorUpdatePattern updatePattern = ComparatorUpdatePattern.NO_UPDATE;
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).m_7071_(Direction.DOWN) : null;
        WorldlyContainer sidedInventory = from instanceof WorldlyContainer ? (WorldlyContainer)from : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            ItemStack itemStack = (ItemStack)fromStackList.get(fromSlot);
            if (itemStack.m_41619_() || sidedInventory != null && !sidedInventory.m_7157_(fromSlot, itemStack, Direction.DOWN)) continue;
            int maxStackSize = Math.min(from.m_6893_(), itemStack.m_41741_());
            int newNumOccupiedSlots = numOccupiedSlots - (itemStack.m_41613_() == 1 ? 1 : 0);
            float g = contentWeight - 1.0f / (float)maxStackSize;
            int newSignalStrength = Mth.m_14143_((float)((g /= (float)from.m_6643_()) * 14.0f)) + (newNumOccupiedSlots > 0 ? 1 : 0);
            updatePattern = newSignalStrength != originalSignalStrength ? updatePattern.thenDecrementUpdateIncrementUpdate() : updatePattern.thenUpdate();
            if (!updatePattern.isChainable()) break;
        }
        return updatePattern;
    }
}

