/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker.nearby;

import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerSection;
import me.jellysquid.mods.lithium.common.util.tuples.Range6Int;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public interface NearbyEntityListener {
    public static final Range6Int EMPTY_RANGE = new Range6Int(0, 0, 0, -1, -1, -1);

    default public void forEachChunkInRangeChange(EntitySectionStorage<? extends EntityAccess> entityCache, SectionPos prevCenterPos, SectionPos newCenterPos) {
        int z;
        int y;
        int x;
        BoundingBox before;
        Range6Int chunkRange = this.getChunkRange();
        if (chunkRange == EMPTY_RANGE) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BoundingBox after = newCenterPos == null ? null : new BoundingBox(newCenterPos.m_123341_() - chunkRange.negativeX(), newCenterPos.m_123342_() - chunkRange.negativeY(), newCenterPos.m_123343_() - chunkRange.negativeZ(), newCenterPos.m_123341_() + chunkRange.positiveX(), newCenterPos.m_123342_() + chunkRange.positiveY(), newCenterPos.m_123343_() + chunkRange.positiveZ());
        BoundingBox boundingBox = before = prevCenterPos == null ? null : new BoundingBox(prevCenterPos.m_123341_() - chunkRange.negativeX(), prevCenterPos.m_123342_() - chunkRange.negativeY(), prevCenterPos.m_123343_() - chunkRange.negativeZ(), prevCenterPos.m_123341_() + chunkRange.positiveX(), prevCenterPos.m_123342_() + chunkRange.positiveY(), prevCenterPos.m_123343_() + chunkRange.positiveZ());
        if (before != null) {
            for (x = before.m_162395_(); x <= before.m_162399_(); ++x) {
                for (y = before.m_162396_(); y <= before.m_162400_(); ++y) {
                    for (z = before.m_162398_(); z <= before.m_162401_(); ++z) {
                        if (after != null && after.m_71051_((Vec3i)pos.m_122178_(x, y, z))) continue;
                        long sectionPos = SectionPos.m_123209_((int)x, (int)y, (int)z);
                        EntitySection trackingSection = entityCache.m_156893_(sectionPos);
                        ((EntityTrackerSection)trackingSection).removeListener(entityCache, this);
                        if (!trackingSection.m_156833_()) continue;
                        entityCache.m_156897_(sectionPos);
                    }
                }
            }
        }
        if (after != null) {
            for (x = after.m_162395_(); x <= after.m_162399_(); ++x) {
                for (y = after.m_162396_(); y <= after.m_162400_(); ++y) {
                    for (z = after.m_162398_(); z <= after.m_162401_(); ++z) {
                        if (before != null && before.m_71051_((Vec3i)pos.m_122178_(x, y, z))) continue;
                        ((EntityTrackerSection)entityCache.m_156893_(SectionPos.m_123209_((int)x, (int)y, (int)z))).addListener(this);
                    }
                }
            }
        }
    }

    public Range6Int getChunkRange();

    public void onEntityEnteredRange(Entity var1);

    public void onEntityLeftRange(Entity var1);

    default public Class<? extends Entity> getEntityClass() {
        return Entity.class;
    }

    default public <T> void onSectionEnteredRange(Object entityTrackingSection, ClassInstanceMultiMap<T> collection) {
        for (Entity entity : collection.m_13533_(this.getEntityClass())) {
            this.onEntityEnteredRange(entity);
        }
    }

    default public <T> void onSectionLeftRange(Object entityTrackingSection, ClassInstanceMultiMap<T> collection) {
        for (Entity entity : collection.m_13533_(this.getEntityClass())) {
            this.onEntityLeftRange(entity);
        }
    }
}

