/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.cached_blockpos_iteration;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;

public class IterateOutwardsCache {
    public static final BlockPos POS_ZERO = new BlockPos(0, 0, 0);
    private final ConcurrentHashMap<Long, LongArrayList> table;
    private final int capacity;
    private final Random random;

    public IterateOutwardsCache(int capacity) {
        this.capacity = capacity;
        this.table = new ConcurrentHashMap(31);
        this.random = new Random();
    }

    private void fillPositionsWithIterateOutwards(LongList entry, int xRange, int yRange, int zRange) {
        for (BlockPos pos : BlockPos.m_121925_((BlockPos)POS_ZERO, (int)xRange, (int)yRange, (int)zRange)) {
            entry.add(pos.m_121878_());
        }
    }

    public LongList getOrCompute(int xRange, int yRange, int zRange) {
        long key = BlockPos.m_121882_((int)xRange, (int)yRange, (int)zRange);
        LongArrayList entry = this.table.get(key);
        if (entry != null) {
            return entry;
        }
        entry = new LongArrayList(128);
        this.fillPositionsWithIterateOutwards((LongList)entry, xRange, yRange, zRange);
        entry.trim();
        LongArrayList previousEntry = this.table.put(key, entry);
        if (previousEntry == null && this.table.size() > this.capacity) {
            Iterator iterator = ((ConcurrentHashMap.KeySetView)this.table.keySet()).iterator();
            for (int i = -this.capacity; iterator.hasNext() && i < 5; ++i) {
                Long key2 = (Long)iterator.next();
                if (this.random.nextInt(8) != 0 || key2 == key) continue;
                iterator.remove();
            }
        }
        return entry;
    }
}

