/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block;

import java.util.ArrayList;
import me.jellysquid.mods.lithium.common.ai.pathing.BlockStatePathingCache;
import me.jellysquid.mods.lithium.common.ai.pathing.PathNodeCache;
import me.jellysquid.mods.lithium.common.block.BlockCountingSection;
import me.jellysquid.mods.lithium.common.block.TrackedBlockStatePredicate;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class BlockStateFlags {
    public static final boolean ENABLED = BlockCountingSection.class.isAssignableFrom(LevelChunkSection.class);
    public static final int NUM_FLAGS;
    public static final TrackedBlockStatePredicate OVERSIZED_SHAPE;
    public static final TrackedBlockStatePredicate PATH_NOT_OPEN;
    public static final TrackedBlockStatePredicate WATER;
    public static final TrackedBlockStatePredicate LAVA;
    public static final TrackedBlockStatePredicate[] ALL_FLAGS;

    static {
        ArrayList<TrackedBlockStatePredicate> allFlags = new ArrayList<TrackedBlockStatePredicate>();
        OVERSIZED_SHAPE = new TrackedBlockStatePredicate(allFlags.size()){

            @Override
            public boolean test(BlockState operand) {
                return operand.m_60779_();
            }
        };
        allFlags.add(OVERSIZED_SHAPE);
        WATER = new TrackedBlockStatePredicate(allFlags.size()){

            @Override
            public boolean test(BlockState operand) {
                return operand.m_60819_().m_76152_().m_205067_(FluidTags.f_13131_);
            }
        };
        allFlags.add(WATER);
        LAVA = new TrackedBlockStatePredicate(allFlags.size()){

            @Override
            public boolean test(BlockState operand) {
                return operand.m_60819_().m_76152_().m_205067_(FluidTags.f_13132_);
            }
        };
        allFlags.add(LAVA);
        if (BlockStatePathingCache.class.isAssignableFrom(BlockBehaviour.BlockStateBase.class)) {
            PATH_NOT_OPEN = new TrackedBlockStatePredicate(allFlags.size()){

                @Override
                public boolean test(BlockState operand) {
                    return PathNodeCache.getNeighborPathNodeType((BlockBehaviour.BlockStateBase)operand) != BlockPathTypes.OPEN;
                }
            };
            allFlags.add(PATH_NOT_OPEN);
        } else {
            PATH_NOT_OPEN = null;
        }
        NUM_FLAGS = allFlags.size();
        ALL_FLAGS = allFlags.toArray(new TrackedBlockStatePredicate[NUM_FLAGS]);
    }
}

