/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StrongNBTFilterItem
extends StringValueFilterItem {
    @Override
    public StringValueData<?> createData(ItemStack stack) {
        return new NBTData(stack);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !player.m_21206_().m_41619_() && player.m_21206_().m_41782_()) {
            NBTData data = (NBTData)this.getStringValueData(player.m_21205_());
            data.setValue(player.m_21206_().m_41783_().m_6426_());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21205_());
        }
        return super.m_7203_(world, player, hand);
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        NBTData data = (NBTData)this.getStringValueData(filter);
        CompoundTag tag1 = data.getValue();
        CompoundTag tag2 = stack.m_41783_();
        return Objects.equals(tag1, tag2);
    }

    @Override
    public String getHelpKey() {
        return "itemfilters.help_text.nbt";
    }

    @Override
    public void getItems(ItemStack filter, Set<Item> set) {
        Registry.f_122827_.forEach(set::add);
    }

    public static class NBTData
    extends StringValueData<CompoundTag> {
        public NBTData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected CompoundTag fromString(String s) {
            if (s.isEmpty()) {
                return null;
            }
            try {
                return TagParser.m_129359_((String)s);
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        protected String toString(CompoundTag value) {
            if (value == null) {
                return "";
            }
            return value.toString();
        }

        @Override
        @Nullable
        public CompoundTag getValue() {
            if (this.load) {
                this.load = false;
                this.value = null;
                if (this.filter.m_41782_() && this.filter.m_41783_().m_128441_("value")) {
                    this.value = this.filter.m_41783_().m_128469_("value");
                }
            }
            return (CompoundTag)this.value;
        }

        @Override
        public void setValue(@Nullable CompoundTag v) {
            this.value = v;
            this.load = false;
            if (this.value == null) {
                this.filter.m_41749_("value");
            } else {
                this.filter.m_41700_("value", (Tag)this.value);
            }
        }

        @Override
        public Component getValueAsComponent() {
            CompoundTag v = this.getValue();
            if (v == null) {
                return TextComponent.f_131282_;
            }
            return NbtUtils.m_178061_((Tag)v);
        }
    }
}

